/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.cli;

import java.net.InetAddress;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.wildfly.filesystem.RealmProvider;

public abstract class BaseWildflyCLIManager {
    protected static final String DEFAULT_HOST = "localhost";
    protected static final int DEFAULT_PORT = 9990;
    protected static final String DEFAULT_ADMIN_USER = null;
    protected static final String DEFAULT_ADMIN_PASSWORD = null;
    protected String host;
    protected int port;
    protected String adminUser;
    protected String adminPassword;
    protected String folderPath;
    protected String levels;
    protected String encoded;

    protected void loadConfig(ConfigProperties config) {
        ConfigProperties.ConfigProperty host = config.get("org.uberfire.ext.security.management.wildfly.cli.host", DEFAULT_HOST);
        ConfigProperties.ConfigProperty port = config.get("org.uberfire.ext.security.management.wildfly.cli.port", Integer.toString(9990));
        ConfigProperties.ConfigProperty user = config.get("org.uberfire.ext.security.management.wildfly.cli.user", DEFAULT_ADMIN_USER);
        ConfigProperties.ConfigProperty password = config.get("org.uberfire.ext.security.management.wildfly.cli.password", DEFAULT_ADMIN_PASSWORD);
        ConfigProperties.ConfigProperty realm = config.get("org.uberfire.ext.security.management.wildfly.cli.folderPath", RealmProvider.DEFAULT_FILE_SYSTEM_REALM_PATH);
        ConfigProperties.ConfigProperty levels = config.get("org.uberfire.ext.security.management.wildfly.cli.levels", "2");
        ConfigProperties.ConfigProperty encoded = config.get("org.uberfire.ext.security.management.wildfly.cli.encoded", "true");
        this.host = host.getValue();
        this.port = Integer.decode(port.getValue());
        this.adminUser = user.getValue();
        this.adminPassword = password.getValue();
        this.folderPath = realm.getValue();
        this.levels = levels.getValue();
        this.encoded = encoded.getValue();
    }

    public ModelControllerClient getClient() throws Exception {
        return ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(this.host), (int)this.port, callbacks -> {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.adminUser);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.adminPassword.toCharArray());
                    continue;
                }
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    rcb.setText(rcb.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        });
    }
}

