/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.False;
import org.dmg.pmml.Field;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLCompoundPredicateFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLFalsePredicateFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLSimplePredicateFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLSimpleSetPredicateFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTruePredicateFactory;

public class KiePMMLPredicateFactory {
    private static final String PREDICATE_NOT_MANAGED = "Predicate %s not managed";

    private KiePMMLPredicateFactory() {
    }

    public static BlockStmt getKiePMMLPredicate(String variableName, Predicate predicate, List<Field<?>> fields) {
        if (predicate instanceof SimplePredicate) {
            return KiePMMLSimplePredicateFactory.getSimplePredicateVariableDeclaration(variableName, (SimplePredicate)predicate, fields);
        }
        if (predicate instanceof SimpleSetPredicate) {
            return KiePMMLSimpleSetPredicateFactory.getSimpleSetPredicateVariableDeclaration(variableName, (SimpleSetPredicate)predicate);
        }
        if (predicate instanceof CompoundPredicate) {
            return KiePMMLCompoundPredicateFactory.getCompoundPredicateVariableDeclaration(variableName, (CompoundPredicate)predicate, fields);
        }
        if (predicate instanceof True) {
            return KiePMMLTruePredicateFactory.getTruePredicateVariableDeclaration(variableName, (True)predicate);
        }
        if (predicate instanceof False) {
            return KiePMMLFalsePredicateFactory.getFalsePredicateVariableDeclaration(variableName, (False)predicate);
        }
        throw new IllegalArgumentException(String.format(PREDICATE_NOT_MANAGED, predicate.getClass()));
    }
}

