/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSource;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceListener;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceStatus;

public abstract class AbstractDataSource
implements DataSource {
    protected javax.sql.DataSource dataSource;
    protected DataSourceStatus status = DataSourceStatus.NEW;
    protected List<DataSourceListener> listeners = new ArrayList<DataSourceListener>();

    @Override
    public DataSourceStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isReferenced() {
        return DataSourceStatus.REFERENCED.equals((Object)this.status);
    }

    @Override
    public boolean isStale() {
        return DataSourceStatus.STALE.equals((Object)this.status);
    }

    @Override
    public boolean isNew() {
        return DataSourceStatus.NEW.equals((Object)this.status);
    }

    @Override
    public void addDataSourceListener(DataSourceListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeDataSourceListener(DataSourceListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyStatusChange(DataSourceStatus newStatus) {
        for (DataSourceListener listener : this.listeners) {
            listener.statusChanged(newStatus);
        }
    }

    public javax.sql.DataSource getInternalDataSource() {
        return this.dataSource;
    }
}

