/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusFluent;
import io.fabric8.kubernetes.api.model.StatusFluentImpl;

public class StatusBuilder
extends StatusFluentImpl<StatusBuilder>
implements VisitableBuilder<Status, StatusBuilder> {
    StatusFluent<?> fluent;
    Boolean validationEnabled;

    public StatusBuilder() {
        this(true);
    }

    public StatusBuilder(Boolean validationEnabled) {
        this(new Status(), validationEnabled);
    }

    public StatusBuilder(StatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatusBuilder(StatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Status(), validationEnabled);
    }

    public StatusBuilder(StatusFluent<?> fluent, Status instance) {
        this(fluent, instance, true);
    }

    public StatusBuilder(StatusFluent<?> fluent, Status instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCode(instance.getCode());
        fluent.withDetails(instance.getDetails());
        fluent.withKind(instance.getKind());
        fluent.withMessage(instance.getMessage());
        fluent.withMetadata(instance.getMetadata());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public StatusBuilder(Status instance) {
        this(instance, (Boolean)true);
    }

    public StatusBuilder(Status instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withCode(instance.getCode());
        this.withDetails(instance.getDetails());
        this.withKind(instance.getKind());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Status build() {
        Status buildable = new Status(this.fluent.getApiVersion(), this.fluent.getCode(), this.fluent.getDetails(), this.fluent.getKind(), this.fluent.getMessage(), this.fluent.getMetadata(), this.fluent.getReason(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusBuilder that = (StatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

