/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOModuleCacheEvent;
import org.guvnor.common.services.project.model.Module;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.datamodel.backend.server.cache.ModuleDataModelOracleBuilderProvider;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
@Named(value="ModuleDataModelOracleCache")
public class LRUModuleDataModelOracleCache
extends LRUCache<KieModule, ModuleDataModelOracle> {
    private ModuleDataModelOracleBuilderProvider builderProvider;
    private KieModuleService moduleService;
    private BuildInfoService buildInfoService;

    public LRUModuleDataModelOracleCache() {
    }

    @Inject
    public LRUModuleDataModelOracleCache(ModuleDataModelOracleBuilderProvider builderProvider, KieModuleService moduleService, BuildInfoService buildInfoService) {
        this.builderProvider = builderProvider;
        this.moduleService = moduleService;
        this.buildInfoService = buildInfoService;
    }

    public void invalidateModuleCache(@Observes InvalidateDMOModuleCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        Path resourcePath = event.getResourcePath();
        KieModule module = (KieModule)this.moduleService.resolveModule(resourcePath);
        if (module != null) {
            this.invalidateCache(module);
        }
    }

    public ModuleDataModelOracle assertModuleDataModelOracle(KieModule module) {
        ModuleDataModelOracle moduleOracle = (ModuleDataModelOracle)this.getEntry(module);
        if (moduleOracle == null) {
            moduleOracle = this.makeModuleOracle(module);
            this.setEntry(module, moduleOracle);
        }
        return moduleOracle;
    }

    private ModuleDataModelOracle makeModuleOracle(KieModule module) {
        return this.builderProvider.newBuilder(module, this.buildInfoService.getBuildInfo((Module)module)).build();
    }
}

