/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.guvnor.common.services.project.backend.server.utils.DependencyUpdater;
import org.guvnor.common.services.project.backend.server.utils.NullSafeEquals;

public class MavenPluginUpdater {
    private final List<Plugin> pluginsDeclaredInPOM;

    public MavenPluginUpdater(List<Plugin> pluginsDeclaredInPOM) {
        this.pluginsDeclaredInPOM = pluginsDeclaredInPOM;
    }

    public List<Plugin> update(List<org.guvnor.common.services.project.model.Plugin> from) {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        for (org.guvnor.common.services.project.model.Plugin plugin : from) {
            if (plugin.getArtifactId() == null || plugin.getGroupId() == null) continue;
            result.add(this.update(plugin, this.findPlugin(plugin.getGroupId(), plugin.getArtifactId())));
        }
        return result;
    }

    private Plugin findPlugin(String groupId, String artifactId) {
        for (Plugin plugin : this.pluginsDeclaredInPOM) {
            if (!NullSafeEquals.areValuesEqual(groupId, plugin.getGroupId()) || !NullSafeEquals.areValuesEqual(artifactId, plugin.getArtifactId())) continue;
            return plugin;
        }
        return new Plugin();
    }

    private Plugin update(org.guvnor.common.services.project.model.Plugin from, Plugin to) {
        to.setGroupId(from.getGroupId());
        to.setArtifactId(from.getArtifactId());
        to.setVersion(from.getVersion());
        if (from.isExtensions()) {
            to.setExtensions(from.isExtensions());
        } else {
            to.setExtensions(null);
        }
        new DependencyUpdater(to.getDependencies()).updateDependencies(from.getDependencies());
        return to;
    }
}

