/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.Map;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.scorecard.compiler.ScorecardCompilationDTO;
import org.kie.pmml.models.scorecard.compiler.factories.KiePMMLCharacteristicsFactory;
import org.kie.pmml.models.scorecard.model.KiePMMLScorecardModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLScorecardModelFactory {
    static final String KIE_PMML_SCORECARD_MODEL_TEMPLATE_JAVA = "KiePMMLScorecardModelTemplate.tmpl";
    static final String KIE_PMML_SCORECARD_MODEL_TEMPLATE = "KiePMMLScorecardModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLScorecardModelFactory.class.getName());

    private KiePMMLScorecardModelFactory() {
    }

    public static KiePMMLScorecardModel getKiePMMLScorecardModel(ScorecardCompilationDTO compilationDTO) {
        Map<String, String> sourcesMap = KiePMMLScorecardModelFactory.getKiePMMLScorecardModelSourcesMap(compilationDTO);
        try {
            Class kiePMMLScorecardModelClass = compilationDTO.compileAndLoadClass(sourcesMap);
            return (KiePMMLScorecardModel)kiePMMLScorecardModelClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLScorecardModelSourcesMap(ScorecardCompilationDTO compilationDTO) {
        String className = compilationDTO.getSimpleClassName();
        String packageName = compilationDTO.getPackageName();
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_SCORECARD_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_SCORECARD_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        String characteristicsClassName = compilationDTO.getCharacteristicsClassName();
        String fullCharacteristicsClassName = String.format("%s.%s", packageName, characteristicsClassName);
        Map<String, String> toReturn = KiePMMLCharacteristicsFactory.getKiePMMLCharacteristicsSourcesMap(compilationDTO);
        KiePMMLScorecardModelFactory.setConstructor(compilationDTO, modelTemplate, fullCharacteristicsClassName);
        String fullClassName = packageName + "." + className;
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(ScorecardCompilationDTO compilationDTO, ClassOrInterfaceDeclaration modelTemplate, String fullCharacteristicsClassName) {
        KiePMMLModelFactoryUtils.init((CompilationDTO)compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = (ExplicitConstructorInvocationStmt)CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        ClassOrInterfaceType characteristicsClass = StaticJavaParser.parseClassOrInterfaceType((String)fullCharacteristicsClassName);
        ObjectCreationExpr characteristicsReference = new ObjectCreationExpr();
        characteristicsReference.setType(characteristicsClass);
        superStatement.setArgument(2, (Expression)characteristicsReference);
        superStatement.setArgument(3, CommonCodegenUtils.getExpressionForObject((Object)compilationDTO.getInitialScore()));
        superStatement.setArgument(4, CommonCodegenUtils.getExpressionForObject((Object)compilationDTO.isUseReasonCodes()));
        REASONCODE_ALGORITHM reasoncodeAlgorithm = compilationDTO.getREASONCODE_ALGORITHM();
        NameExpr reasonCodeExpr = new NameExpr(REASONCODE_ALGORITHM.class.getName() + "." + reasoncodeAlgorithm.name());
        superStatement.setArgument(5, (Expression)reasonCodeExpr);
        superStatement.setArgument(6, CommonCodegenUtils.getExpressionForObject((Object)compilationDTO.getBaselineScore()));
    }
}

