/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.kie.server.api.security.SecurityAdapter;
import org.kie.server.services.impl.security.BaseIdentityProvider;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronIdentityProvider
extends BaseIdentityProvider {
    public static boolean available() {
        try {
            Class.forName("org.wildfly.security.auth.server.SecurityDomain");
            return SecurityDomain.getCurrent() != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getName() {
        if (!this.contextUsers.isEmpty()) {
            return (String)this.contextUsers.peek();
        }
        Optional<SecurityIdentity> identity = this.getCurrentSecurityIdentity();
        if (identity.isPresent() && identity != null && identity.get().getPrincipal() != null && !Objects.equals("anonymous", identity.get().getPrincipal().getName())) {
            return identity.get().getPrincipal().getName();
        }
        return this.getNameFromAdapter();
    }

    public List<String> getRoles() {
        if (!this.contextUsers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(this.getRolesFromSecurityIdentity());
        roles.addAll(this.getRolesFromAdapter());
        return roles;
    }

    public boolean hasRole(String s) {
        if (this.getRolesFromSecurityIdentity().contains(s)) {
            return true;
        }
        for (SecurityAdapter adapter : this.adapters) {
            List adapterRoles = adapter.getRoles(new Object[0]);
            if (adapterRoles == null || !adapterRoles.contains(s)) continue;
            return true;
        }
        return false;
    }

    private List<String> getRolesFromSecurityIdentity() {
        ArrayList<String> result = new ArrayList<String>();
        Optional<SecurityIdentity> identity = this.getCurrentSecurityIdentity();
        if (identity.isPresent()) {
            for (String role : identity.get().getRoles()) {
                result.add(role);
            }
        }
        return result;
    }

    private Optional<SecurityIdentity> getCurrentSecurityIdentity() {
        SecurityDomain securityDomain = SecurityDomain.getCurrent();
        if (securityDomain == null) {
            return Optional.empty();
        }
        return Optional.of(securityDomain.getCurrentSecurityIdentity());
    }
}

