/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl.storage.cloud;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.services.impl.KieServerLocator;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepositoryUtils;
import org.kie.server.services.openshift.api.KieServerOpenShift;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateCloudRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerStateOpenShiftRepository
extends KieServerStateCloudRepository
implements KieServerOpenShift {
    private static final Logger logger = LoggerFactory.getLogger(KieServerStateOpenShiftRepository.class);

    public synchronized void create(KieServerState kieServerState) {
        String serverId = this.retrieveKieServerId(kieServerState);
        this.processKieServerStateByOpenShift(client -> {
            if (this.getKieServerCM((OpenShiftClient)client, serverId).isPresent()) {
                logger.info("Create new ConfigMap action ignored. ConfigMap for KieServer [{}] exists.", (Object)serverId);
            } else {
                this.createOrReplaceKieServerStateCM((OpenShiftClient)client, serverId, kieServerState);
            }
            return null;
        });
    }

    public List<String> retrieveAllKieServerIds() {
        return this.processKieServerStateByOpenShift(client -> ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)client.configMaps().inNamespace(client.getNamespace())).withLabelSelector(this.getKieServerCMLabelSelector((OpenShiftClient)client))).list()).getItems().stream().map(cfg -> (String)cfg.getMetadata().getLabels().get("services.server.kie.org/kie-server-id")).collect(Collectors.toList()));
    }

    public List<KieServerState> retrieveAllKieServerStates() {
        return this.processKieServerStateByOpenShift(client -> ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)client.configMaps().inNamespace(client.getNamespace())).withLabelSelector(this.getKieServerCMLabelSelector((OpenShiftClient)client))).list()).getItems().stream().map(this::getKieServerState).collect(Collectors.toList()));
    }

    public boolean exists(String id) {
        return this.processKieServerStateByOpenShift(client -> this.getKieServerCM((OpenShiftClient)client, id).isPresent());
    }

    public KieServerState delete(String id) {
        KieServerState state = this.load(id);
        boolean isUnsupported = this.processKieServerStateByOpenShift(client -> {
            if (this.getKieServerDC((OpenShiftClient)client, id).isPresent()) {
                return true;
            }
            ((FilterWatchListDeletable)((NonNamespaceOperation)client.configMaps().inNamespace(client.getNamespace())).withLabel("services.server.kie.org/kie-server-id", id)).delete();
            return false;
        });
        if (isUnsupported) {
            throw new UnsupportedOperationException("Can not delete attached KieServerState with id [" + id + "]");
        }
        return state;
    }

    public synchronized void store(String serverId, KieServerState kieServerState) {
        if (!this.retrieveKieServerId(kieServerState).equals(serverId)) {
            throw new IllegalArgumentException("Invalid KieServerId: Id does not match with KieServerState.");
        }
        this.processKieServerStateByOpenShift(client -> {
            Optional cmOpt = this.getKieServerCM((OpenShiftClient)client, serverId);
            if (Boolean.parseBoolean(kieServerState.getConfiguration().getConfigItemValue("org.kie.server.state.immutable", Boolean.FALSE.toString()))) {
                if (Boolean.parseBoolean(System.getProperty("org.kie.server.state.immutable.init", Boolean.FALSE.toString()))) {
                    this.createOrReplaceKieServerStateCM((OpenShiftClient)client, serverId, kieServerState);
                } else {
                    logger.debug("Overwrite immutable KieServer[id:{}] state is not allowed.", (Object)serverId);
                }
            } else {
                ConfigMap cm = (ConfigMap)cmOpt.orElseThrow(() -> new IllegalStateException("KieServerState ConfigMap must exist before update."));
                if (this.isServerStateUpdateAllowed((OpenShiftClient)client, serverId, cm, kieServerState)) {
                    ObjectMeta md = cm.getMetadata();
                    Map<String, String> ann = md.getAnnotations() == null ? new ConcurrentHashMap() : md.getAnnotations();
                    md.setAnnotations(ann);
                    ann.put("services.server.kie.org/kie-server-state.changeTimestamp", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
                    ann.put("services.server.kie.org/openshift-startup-strategy.rolloutRequired", "true");
                    cm.setData(Collections.singletonMap("kie-server-state", this.xs.toXML((Object)kieServerState)));
                    this.createOrReplaceCM((OpenShiftClient)client, cm);
                }
            }
            return null;
        });
    }

    public KieServerState load(String serverId) {
        if (serverId == null) {
            return null;
        }
        KieServerState kieServerState = this.processKieServerStateByOpenShift(client -> {
            Optional cmOpt = this.getKieServerCM((OpenShiftClient)client, serverId);
            if (this.isKieServerRuntime() && this.getKieServerDC((OpenShiftClient)client, serverId).isPresent()) {
                ConfigMap kieCM = cmOpt.filter(cm -> !cm.getMetadata().getLabels().containsValue("DETACHED")).orElseGet(() -> {
                    KieServerState state = cmOpt.map(this::getKieServerState).orElseGet(KieServerState::new);
                    KieServerConfig config = Optional.ofNullable(state.getConfiguration()).orElseGet(() -> {
                        state.setConfiguration(new KieServerConfig());
                        return state.getConfiguration();
                    });
                    KieServerStateRepositoryUtils.populateWithSystemProperties((KieServerConfig)config);
                    if (config.getConfigItemValue("org.kie.server.id") == null || !config.getConfigItemValue("org.kie.server.id").equals(serverId)) {
                        throw new IllegalStateException("KieServerId: [" + serverId + "], must NOT be null and be set by system property or environment variable.");
                    }
                    return this.createOrReplaceKieServerStateCM((OpenShiftClient)client, serverId, state);
                });
                return this.getKieServerState(kieCM);
            }
            if (cmOpt.isPresent()) {
                return this.getKieServerState((ConfigMap)cmOpt.get());
            }
            return null;
        });
        if (kieServerState == null) {
            if (this.isKieServerRuntime()) {
                throw new IllegalStateException("Invalid KieServerId: [" + serverId + "], load kie server state failed.");
            }
        } else if (!this.retrieveKieServerId(kieServerState).equals(serverId)) {
            throw new IllegalStateException("Inconsistent kie server state data, requested KieServerId: [" + serverId + "], whereas loaded KieServerId: [" + this.retrieveKieServerId(kieServerState) + "],from kie server state.");
        }
        return kieServerState;
    }

    public Optional<String> getAppName(OpenShiftClient client, String serverId) {
        Optional<String> appNameFromDC = this.getKieServerDC(client, serverId).map(dc -> (String)dc.getMetadata().getLabels().get("application"));
        return appNameFromDC.isPresent() ? appNameFromDC : this.getAppNameFromPod(client);
    }

    public Optional<String> getAppNameFromPod(OpenShiftClient client) {
        Optional<Pod> pod = Optional.ofNullable((Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(client.getNamespace())).withName(System.getenv("HOSTNAME"))).get());
        return pod.map(p -> (String)p.getMetadata().getLabels().get("application"));
    }

    public LabelSelector getKieServerCMLabelSelector(OpenShiftClient client) {
        ArrayList<LabelSelectorRequirement> selectorReqs = new ArrayList<LabelSelectorRequirement>();
        Optional<String> appName = this.getAppNameFromPod(client);
        selectorReqs.add(((LabelSelectorRequirementBuilder)((LabelSelectorRequirementBuilder)((LabelSelectorRequirementBuilder)new LabelSelectorRequirementBuilder().withKey("services.server.kie.org/kie-server-state")).withOperator("In")).withValues(new String[]{"IMMUTABLE", "USED", "DETACHED"})).build());
        if (!this.isKieServerGlobalDiscoveryEnabled() && appName.isPresent()) {
            selectorReqs.add(((LabelSelectorRequirementBuilder)((LabelSelectorRequirementBuilder)((LabelSelectorRequirementBuilder)new LabelSelectorRequirementBuilder().withKey("application")).withOperator("In")).withValues(new String[]{appName.get()})).build());
        }
        return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchExpressions(selectorReqs)).build();
    }

    @Override
    public boolean isKieServerReady() {
        return KieServerLocator.getInstance().isKieServerReady();
    }

    public boolean isKieContainerRemovalAllowed(ConfigMap cm, KieServerState newState) {
        KieServerState state = (KieServerState)this.xs.fromXML((String)cm.getData().get("kie-server-state"));
        for (KieContainerResource container : state.getContainers()) {
            if (!container.getStatus().equals((Object)KieContainerStatus.STOPPED) || !newState.getContainers().stream().noneMatch(c -> c.getContainerId().equals(container.getContainerId()))) continue;
            logger.warn("Removing STOPPED KieContainer by KieServer process is not allowed.");
            return false;
        }
        return true;
    }

    public boolean isKieContainerUpdateDuringRolloutAllowed(ConfigMap cm, KieServerState newState) {
        KieServerState state = (KieServerState)this.xs.fromXML((String)cm.getData().get("kie-server-state"));
        for (KieContainerResource container : state.getContainers()) {
            if (!container.getStatus().equals((Object)KieContainerStatus.STARTED) || !newState.getContainers().stream().anyMatch(c -> c.getContainerId().equals(container.getContainerId()) && c.getStatus().equals((Object)KieContainerStatus.STOPPED))) continue;
            logger.warn("Non KieServer process updated KieServerState during DC rollout for STOPPING containers.");
            return true;
        }
        logger.warn("Non KieServer process updates KieServerState during DC rollout is prohibited!");
        return false;
    }

    public ConfigMap createOrReplaceKieServerStateCM(OpenShiftClient client, String serverId, KieServerState kieServerState) {
        HashMap<String, String> labels = new HashMap<String, String>();
        Optional<String> appName = this.getAppName(client, serverId);
        Optional dcOpt = this.getKieServerDC(client, serverId);
        String cfgMapName = dcOpt.map(dc -> dc.getMetadata().getName()).orElseGet(() -> this.getKieServerCMSyntheticName(client));
        kieServerState.getConfiguration().addConfigItem(new KieServerConfigItem("org.kie.server.services.openshift.service.name", cfgMapName, String.class.getName()));
        appName.ifPresent(aName -> labels.put("application", (String)aName));
        labels.put("services.server.kie.org/kie-server-id", serverId);
        if (Boolean.parseBoolean(kieServerState.getConfiguration().getConfigItemValue("org.kie.server.state.immutable", "false"))) {
            labels.put("services.server.kie.org/kie-server-state", "IMMUTABLE");
        } else if (kieServerState.getConfiguration().getConfigItem("org.kie.server.location") == null) {
            labels.put("services.server.kie.org/kie-server-state", "DETACHED");
        } else {
            labels.put("services.server.kie.org/kie-server-state", "USED");
        }
        return dcOpt.map(dc -> this.createOrReplaceCM(client, ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(cfgMapName)).withLabels(labels)).withOwnerReferences(new OwnerReference[]{((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)new OwnerReferenceBuilder().withApiVersion(dc.getApiVersion())).withKind(dc.getKind())).withName(dc.getMetadata().getName())).withUid(dc.getMetadata().getUid())).build()})).endMetadata()).withData(Collections.singletonMap("kie-server-state", this.xs.toXML((Object)kieServerState)))).build())).orElseGet(() -> this.createOrReplaceCM(client, ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(cfgMapName)).withLabels(labels)).endMetadata()).withData(Collections.singletonMap("kie-server-state", this.xs.toXML((Object)kieServerState)))).build()));
    }

    public ConfigMap createOrReplaceCM(OpenShiftClient client, ConfigMap cm) {
        return (ConfigMap)((NonNamespaceOperation)client.configMaps().inNamespace(client.getNamespace())).createOrReplace((Object[])new ConfigMap[]{cm});
    }

    private KieServerState getKieServerState(ConfigMap cm) {
        return Optional.of(cm).filter(kieCM -> kieCM.getMetadata().getLabels().containsValue("DETACHED")).map(this::getKieServerStateFromCMWithoutLocation).orElseGet(() -> this.getKieServerStateFromCM(cm));
    }

    private KieServerState getKieServerStateFromCMWithoutLocation(ConfigMap cm) {
        KieServerState state = (KieServerState)this.xs.fromXML((String)cm.getData().get("kie-server-state"));
        state.getConfiguration().removeConfigItem(state.getConfiguration().getConfigItem("org.kie.server.location"));
        return state;
    }

    private KieServerState getKieServerStateFromCM(ConfigMap cm) {
        return (KieServerState)this.xs.fromXML((String)cm.getData().get("kie-server-state"));
    }

    private String getKieServerCMSyntheticName(OpenShiftClient client) {
        String appName = this.getAppNameFromPod(client).orElse("unknown");
        int index = ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)client.configMaps().inNamespace(client.getNamespace())).withLabelSelector(this.getKieServerCMLabelSelector(client))).list()).getItems().size() + 1;
        return appName + "-" + "kieserver" + "-" + index;
    }

    private boolean isServerStateUpdateAllowed(OpenShiftClient client, String serverId, ConfigMap cm, KieServerState newState) {
        if (cm.getMetadata().getLabels() == null) {
            return false;
        }
        if (cm.getMetadata().getLabels().containsValue("DETACHED")) {
            return !this.isKieServerRuntime();
        }
        if (cm.getMetadata().getLabels().containsValue("USED")) {
            if (this.isKieServerRuntime()) {
                return this.isUpdateByKieServerProcessAllowed(client, serverId, cm, newState);
            }
            return this.isUpdateByNonKieServerProcessAllowed(client, serverId, cm, newState);
        }
        if (cm.getMetadata().getLabels().containsValue("IMMUTABLE")) {
            logger.warn("Add or remove kie container not allowed for immutable kie server: {}", cm.getMetadata().getLabels().get("services.server.kie.org/kie-server-id"));
        }
        return false;
    }

    private boolean isUpdateByNonKieServerProcessAllowed(OpenShiftClient client, String serverId, ConfigMap cm, KieServerState newState) {
        Optional dcOpt = this.getKieServerDC(client, serverId);
        if (dcOpt.isPresent()) {
            if (this.isDCStable((DeploymentConfig)dcOpt.get())) {
                logger.debug("Non KieServer process updated KieServerState.");
                return true;
            }
            return this.isKieContainerUpdateDuringRolloutAllowed(cm, newState);
        }
        return true;
    }

    private boolean isUpdateByKieServerProcessAllowed(OpenShiftClient client, String serverId, ConfigMap cm, KieServerState newState) {
        DeploymentConfig dc = (DeploymentConfig)this.getKieServerDC(client, serverId).orElseThrow(IllegalStateException::new);
        if (!this.isKieContainerRemovalAllowed(cm, newState)) {
            return false;
        }
        if (!this.isKieServerReady()) {
            logger.debug("KieServerState updates during KieServer starting up is ignored!");
            return false;
        }
        if (!this.isDCStable(dc)) {
            logger.debug("KieServerState updates during DC rollout is ignored!");
            return false;
        }
        logger.debug("KieServer process updated KieServerState.");
        return true;
    }

    private boolean isKieServerRuntime() {
        return System.getProperty("org.kie.server.id") != null;
    }

    private boolean isKieServerGlobalDiscoveryEnabled() {
        return Boolean.parseBoolean(System.getProperty("org.kie.server.controller.openshift.global.discovery.enabled", "false"));
    }

    private <R> R processKieServerStateByOpenShift(Function<OpenShiftClient, R> func) {
        R result = null;
        try (OpenShiftClient client = this.createOpenShiftClient();){
            result = func.apply(client);
        }
        catch (UnsupportedOperationException uoe) {
            logger.error("Processing KieServerState failed - Unsupported", (Throwable)uoe);
            throw uoe;
        }
        catch (IllegalStateException ise) {
            logger.error("Processing KieServerState failed - Missing required configuration", (Throwable)ise);
            throw ise;
        }
        catch (KubernetesClientException kce) {
            if (kce.getMessage().contains("already exists")) {
                logger.debug("ConfigMap already created, ignoring...", (Throwable)kce);
            } else {
                logger.warn("Processing KieServerState failed.", (Throwable)kce);
            }
        }
        catch (Exception e) {
            logger.error("Processing KieServerState failed.", (Throwable)e);
        }
        return result;
    }
}

