/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.backend.server;

import java.util.Collections;
import java.util.function.BiFunction;
import org.jbpm.workbench.ht.model.TaskAssignmentSummary;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.instance.TaskInstance;

public class TaskAssignmentSummaryMapper
implements BiFunction<TaskInstance, IdentityProvider, TaskAssignmentSummary> {
    @Override
    public TaskAssignmentSummary apply(TaskInstance task, IdentityProvider identityProvider) {
        if (task == null) {
            return null;
        }
        TaskAssignmentSummary summary = new TaskAssignmentSummary();
        summary.setTaskId(task.getId());
        summary.setActualOwner(task.getActualOwner());
        summary.setTaskName(task.getName());
        summary.setPotOwnersString(task.getPotentialOwners());
        summary.setCreatedBy(task.getCreatedBy());
        summary.setBusinessAdmins(task.getBusinessAdmins());
        summary.setStatus(task.getStatus());
        summary.setDelegationAllowed(this.isDelegationAllowed(task, identityProvider));
        summary.setForwardAllowed(this.isForwardAllowed(task, identityProvider));
        summary.setDeploymentId(task.getContainerId());
        return summary;
    }

    protected Boolean isForwardAllowed(TaskInstance task, IdentityProvider identityProvider) {
        return this.isReassignmentAllowed(task, identityProvider);
    }

    protected Boolean isDelegationAllowed(TaskInstance task, IdentityProvider identityProvider) {
        return this.isReassignmentAllowed(task, identityProvider);
    }

    private Boolean isReassignmentAllowed(TaskInstance task, IdentityProvider identityProvider) {
        if (TaskStatus.TASK_STATUS_READY.equals(task.getStatus())) {
            if (this.currentUserIsPotentialOwner(identityProvider, task)) {
                return true;
            }
            if (this.currentUserIsBusinessAdministrator(identityProvider, task)) {
                return true;
            }
        } else if (TaskStatus.TASK_STATUS_IN_PROGRESS.equals(task.getStatus()) || TaskStatus.TASK_STATUS_RESERVED.equals(task.getStatus())) {
            if (this.currentUserIsOwner(identityProvider, task)) {
                return true;
            }
            if (this.currentUserIsBusinessAdministrator(identityProvider, task)) {
                return true;
            }
        }
        return false;
    }

    private boolean currentUserIsPotentialOwner(IdentityProvider identityProvider, TaskInstance task) {
        if (task != null && task.getPotentialOwners() != null && identityProvider != null) {
            return !Collections.disjoint(task.getPotentialOwners(), identityProvider.getRoles());
        }
        return false;
    }

    private boolean currentUserIsBusinessAdministrator(IdentityProvider identityProvider, TaskInstance task) {
        if (task != null && task.getBusinessAdmins() != null && identityProvider != null) {
            return !Collections.disjoint(task.getBusinessAdmins(), identityProvider.getRoles());
        }
        return false;
    }

    private boolean currentUserIsOwner(IdentityProvider identityProvider, TaskInstance task) {
        return identityProvider.getName().equals(task.getActualOwner());
    }
}

