/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.query.jpa.data.QueryCriteria;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.query.jpa.impl.QueryAndParameterAppender;
import org.kie.internal.query.QueryParameterIdentifiers;

public class QueryHelper {
    private static final Map<String, String> criteriaFields = new ConcurrentHashMap<String, String>();
    private static final Map<String, Class<?>> criteriaFieldClasses = new ConcurrentHashMap();

    private QueryHelper() {
    }

    public static void addCriteria(String listId, String fieldName, Class<?> type) {
        criteriaFields.put(listId, fieldName);
        criteriaFieldClasses.put(listId, type);
    }

    public static QueryAndParameterAppender createQueryWithSubQuery(String queryBase, QueryWhere queryWhere, Map<String, Object> queryParams, String subQuery) {
        QueryAndParameterAppender queryAppender = QueryHelper.createQuery(queryBase, queryWhere, queryParams, 0);
        if (subQuery != null && !subQuery.isEmpty()) {
            queryAppender.addToQueryBuilder(subQuery, false);
        }
        return queryAppender;
    }

    public static QueryAndParameterAppender createQuery(String queryBase, QueryWhere queryWhere, Map<String, Object> queryParams, int queryParamId) {
        boolean addWhereClause;
        QueryAndParameterAppender queryAppender = new QueryAndParameterAppender(new StringBuilder(queryBase), queryParams, queryParamId);
        boolean addLastCriteria = false;
        ArrayList<Object[]> varValCriteriaList = new ArrayList<Object[]>();
        List queryWhereCriteriaList = queryWhere.getCriteria();
        QueryHelper.checkVarValCriteria(queryWhere, varValCriteriaList);
        Iterator iter = queryWhereCriteriaList.iterator();
        while (iter.hasNext()) {
            QueryCriteria criteria = (QueryCriteria)iter.next();
            if (!QueryParameterIdentifiers.LAST_VARIABLE_LIST.equals(criteria.getListId())) continue;
            addLastCriteria = true;
            iter.remove();
        }
        block6: for (QueryCriteria criteria : queryWhere.getCriteria()) {
            String listId = criteria.getListId();
            switch (criteria.getType()) {
                case NORMAL: {
                    queryAppender.addQueryParameters(criteria.getParameters(), listId, criteriaFieldClasses.get(listId), criteriaFields.get(listId), criteria.isUnion());
                    continue block6;
                }
                case RANGE: {
                    queryAppender.addRangeQueryParameters(criteria.getParameters(), listId, criteriaFieldClasses.get(listId), criteriaFields.get(listId), criteria.isUnion());
                    continue block6;
                }
                case REGEXP: {
                    List<String> stringParams = QueryHelper.castToStringList(criteria.getParameters());
                    queryAppender.addRegexQueryParameters(stringParams, listId, criteriaFields.get(listId), criteria.isUnion());
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown criteria type in delete query builder: " + criteria.getType().toString());
        }
        while (queryAppender.getParenthesesNesting() > 0) {
            queryAppender.closeParentheses();
        }
        boolean bl = addWhereClause = !queryAppender.hasBeenUsed();
        if (!varValCriteriaList.isEmpty()) {
            QueryHelper.addVarValCriteria(addWhereClause, queryAppender, "l", varValCriteriaList);
            addWhereClause = false;
        }
        if (addLastCriteria) {
            QueryHelper.addLastInstanceCriteria(queryAppender);
        }
        return queryAppender;
    }

    private static List<String> castToStringList(List<Object> objectList) {
        ArrayList<String> stringList = new ArrayList<String>(objectList.size());
        for (Object obj : objectList) {
            stringList.add(obj.toString());
        }
        return stringList;
    }

    public static void checkVarValCriteria(QueryWhere queryWhere, List<Object[]> varValCriteriaList) {
        LinkedList<QueryCriteria> varValCriteria = new LinkedList<QueryCriteria>();
        Iterator iter = queryWhere.getCriteria().iterator();
        while (iter.hasNext()) {
            QueryCriteria criteria = (QueryCriteria)iter.next();
            if (!QueryParameterIdentifiers.VAR_VALUE_ID_LIST.equals(criteria.getListId())) continue;
            varValCriteria.add(criteria);
            iter.remove();
        }
        if (varValCriteria.isEmpty()) {
            return;
        }
        for (QueryCriteria criteria : varValCriteria) {
            for (Object varVal : criteria.getParameters()) {
                String[] parts = ((String)varVal).split(":", 2);
                String varId = parts[1].substring(0, Integer.parseInt(parts[0]));
                String val = parts[1].substring(Integer.parseInt(parts[0]) + 1);
                int type = (criteria.isUnion() ? 0 : 1) + (criteria.getType().equals((Object)QueryWhere.QueryCriteriaType.REGEXP) ? 2 : 0);
                Object[] varValCrit = new Object[]{type, varId, val};
                varValCriteriaList.add(varValCrit);
            }
        }
    }

    public static void addVarValCriteria(boolean addWhereClause, QueryAndParameterAppender queryAppender, String tableId, List<Object[]> varValCriteriaList) {
        for (Object[] varValCriteria : varValCriteriaList) {
            String val;
            boolean union = (Integer)varValCriteria[0] % 2 == 0;
            String varIdQueryParamName = queryAppender.generateParamName();
            queryAppender.addNamedQueryParam(varIdQueryParamName, varValCriteria[1]);
            StringBuilder queryPhraseBuilder = new StringBuilder(" ( ").append(tableId).append(".variableId = :").append(varIdQueryParamName).append(" ");
            queryPhraseBuilder.append("AND ").append(tableId).append(".value ");
            String valQueryParamName = queryAppender.generateParamName();
            if ((Integer)varValCriteria[0] >= 2) {
                val = ((String)varValCriteria[2]).replace('*', '%').replace('.', '_');
                queryPhraseBuilder.append("like :").append(valQueryParamName);
            } else {
                val = (String)varValCriteria[2];
                queryPhraseBuilder.append("= :").append(valQueryParamName);
            }
            queryPhraseBuilder.append(" ) ");
            String[] valArr = new String[]{val};
            queryAppender.addToQueryBuilder(queryPhraseBuilder.toString(), union, valQueryParamName, Arrays.asList(valArr));
        }
    }

    private static void addLastInstanceCriteria(QueryAndParameterAppender queryAppender) {
        String lastQueryPhrase = "(l.id IN " + "(SELECT MAX(ll.id) FROM VariableInstanceLog ll GROUP BY ll.variableId, ll.processInstanceId)" + ") ";
        queryAppender.addToQueryBuilder(lastQueryPhrase, false);
    }
}

