/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Module;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
public class DataSourceServicesHelper {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceServicesHelper.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private DefRegistry defRegistry;
    @Inject
    protected SpacesAPI spacesAPI;
    private Path root;
    private FileSystem fileSystem;

    @PostConstruct
    protected void init() {
        URI repositoryURI = null;
        try {
            repositoryURI = this.spacesAPI.resolveFileSystemURI(SpacesAPI.Scheme.DEFAULT, SpacesAPI.DEFAULT_SPACE, this.getGlobalFileSystemName());
            this.fileSystem = this.ioService.newFileSystem(repositoryURI, (Map)new HashMap<String, Object>(){
                {
                    this.put("init", Boolean.TRUE);
                    this.put("internal", Boolean.TRUE);
                }
            });
            logger.debug("Data sources platform repository: {} was successfully created.", (Object)repositoryURI);
        }
        catch (FileSystemAlreadyExistsException e) {
            logger.debug("Data sources platform repository: {} already exits and will be used.", repositoryURI);
            this.fileSystem = this.ioService.getFileSystem(repositoryURI);
        }
        this.root = (Path)this.fileSystem.getRootDirectories().iterator().next();
    }

    public org.uberfire.backend.vfs.Path getGlobalDataSourcesContext() {
        return Paths.convert((Path)this.root);
    }

    public org.uberfire.backend.vfs.Path getModuleDataSourcesContext(Module module) {
        org.uberfire.backend.vfs.Path rootPath = module.getRootPath();
        Path dataSourcesNioPath = Paths.convert((org.uberfire.backend.vfs.Path)rootPath).resolve("src/main/resources/META-INF");
        return Paths.convert((Path)dataSourcesNioPath);
    }

    public DefRegistry getDefRegistry() {
        return this.defRegistry;
    }

    public boolean isDriverFile(org.uberfire.backend.vfs.Path path) {
        return path != null && path.getFileName().endsWith(".driver");
    }

    public boolean isDataSourceFile(org.uberfire.backend.vfs.Path path) {
        return path != null && path.getFileName().endsWith(".datasource");
    }

    private String getGlobalFileSystemName() {
        String name = System.getProperty("org.kie.workbench.datasource-filesystem");
        if (name == null || "".equals(name)) {
            name = "datasources";
        }
        return name;
    }
}

