/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.examples.backend.server.BaseProjectImportService;
import org.kie.workbench.common.screens.examples.backend.server.ImportExamplesException;
import org.kie.workbench.common.screens.examples.model.Credentials;
import org.kie.workbench.common.screens.examples.model.ExampleOrganizationalUnit;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ExamplesMetaData;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ExamplesService;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidators;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.fs.jgit.FileSystemLock;
import org.uberfire.java.nio.fs.jgit.FileSystemLockManager;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;

@Service
@ApplicationScoped
public class ExamplesServiceImpl
extends BaseProjectImportService
implements ExamplesService {
    private static final Logger logger = LoggerFactory.getLogger(ExamplesServiceImpl.class);
    private static final int LAST_ACCESS_THRESHOLD = 10;
    private static final TimeUnit LAST_ACCESS_TIME_UNIT = TimeUnit.SECONDS;
    private static final String LOCK_NAME = "playground.lock";
    private static final String PREFIX = ".playground-";
    private static final String KIE_WB_PLAYGROUND_ZIP = "org/kie/kie-wb-playground/kie-wb-playground.zip";
    private static final String DONE_MARKER_NAME = ".done";
    private static final String DEFAULT_GROUP_ID = "org.kie.playground";
    private static final String PLAYGROUND_DIRECTORY = ".kie-wb-playground";
    private RepositoryFactory repositoryFactory;
    private OrganizationalUnitService ouService;
    private final FileSystem systemFS;
    private ExampleRepository playgroundRepository;
    protected String md5;
    protected String playgroundSpaceName;
    protected File playgroundRootDirectory;

    @Inject
    public ExamplesServiceImpl(@Named(value="ioStrategy") IOService ioService, RepositoryFactory repositoryFactory, KieModuleService moduleService, OrganizationalUnitService ouService, WorkspaceProjectService projectService, MetadataService metadataService, Event<NewProjectEvent> newProjectEvent, ProjectScreenService projectScreenService, ImportProjectValidators validators, SpaceConfigStorageRegistry spaceConfigStorageRegistry, @Named(value="systemFS") FileSystem systemFS, PathUtil pathUtil, RepositoryService repoService) {
        super(ioService, metadataService, validators, moduleService, projectService, projectScreenService, spaceConfigStorageRegistry, pathUtil, repoService, newProjectEvent);
        this.ioService = ioService;
        this.repositoryFactory = repositoryFactory;
        this.moduleService = moduleService;
        this.ouService = ouService;
        this.projectService = projectService;
        this.metadataService = metadataService;
        this.projectScreenService = projectScreenService;
        this.validators = validators;
        this.systemFS = systemFS;
    }

    @PostConstruct
    public void initPlaygroundRepository() {
        URL resource = this.getClass().getClassLoader().getResource(KIE_WB_PLAYGROUND_ZIP);
        if (resource == null) {
            logger.warn("Playground repository jar not found on classpath.");
            return;
        }
        String userDir = System.getProperty("user.dir");
        this.md5 = this.calculateMD5(resource);
        this.playgroundRootDirectory = new File(userDir, PLAYGROUND_DIRECTORY);
        File playgroundDirectory = new File(this.playgroundRootDirectory, this.md5);
        File doneMarker = new File(playgroundDirectory, DONE_MARKER_NAME);
        this.playgroundSpaceName = PREFIX + this.md5;
        String repositoryUrl = this.resolveRepositoryUrl(playgroundDirectory.getAbsolutePath());
        if (!playgroundDirectory.exists()) {
            playgroundDirectory.mkdirs();
        }
        FileSystemLock physicalLock = this.createLock();
        try {
            physicalLock.lock();
            if (!doneMarker.exists()) {
                this.unzipPlayground(resource, playgroundDirectory);
                doneMarker.createNewFile();
            }
            if (!this.existSpace(this.playgroundSpaceName)) {
                this.createPlaygroundHiddenSpace(this.md5);
                this.spaceConfigStorageRegistry.getBatch(this.playgroundSpaceName).run(spaceConfigStorageBatchContext -> {
                    this.deleteOldPlaygrounds(this.md5);
                    this.deleteOldHiddenSpaces(this.md5);
                    this.cloneRepository(repositoryUrl);
                    return null;
                });
            }
        }
        catch (Exception e) {
            String message = "Can't create examples playground";
            logger.error(message);
            throw new ImportExamplesException(message, e);
        }
        finally {
            physicalLock.unlock();
        }
        this.playgroundRepository = new ExampleRepository(repositoryUrl);
    }

    private FileSystemLock createLock() {
        return FileSystemLockManager.getInstance().getFileSystemLock(this.playgroundRootDirectory, LOCK_NAME, LAST_ACCESS_TIME_UNIT, 10L);
    }

    private ExampleRepository unzipPlayground(URL resource, File playgroundDirectory) {
        ExampleRepository exampleRepository;
        ZipInputStream inputStream = new ZipInputStream(resource.openStream());
        try {
            ZipEntry zipEntry;
            while ((zipEntry = inputStream.getNextEntry()) != null) {
                byte[] buffer = new byte[1024];
                File file = new File(playgroundDirectory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                try (FileOutputStream fos = new FileOutputStream(file);){
                    int read = -1;
                    while ((read = inputStream.read(buffer)) != -1) {
                        fos.write(buffer, 0, read);
                    }
                }
            }
            Git git = Git.init().setBare(false).setDirectory(playgroundDirectory).call();
            git.add().addFilepattern(".").call();
            git.commit().setMessage("Initial commit").call();
            String repositoryUrl = this.resolveRepositoryUrl(playgroundDirectory.getAbsolutePath());
            exampleRepository = new ExampleRepository(repositoryUrl);
        }
        catch (Throwable zipEntry) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    zipEntry.addSuppressed(throwable);
                }
                throw zipEntry;
            }
            catch (IOException | GitAPIException e) {
                String message = "Unable to initialize playground git repository. Only custom repository definition will be available in the Workbench.";
                logger.error(message, e);
                throw new ImportExamplesException(message, e);
            }
        }
        inputStream.close();
        return exampleRepository;
    }

    protected void deleteOldHiddenSpaces(String md5) {
        this.ouService.getAllOrganizationalUnits(false, this::isOldPlayground).forEach(space -> this.ouService.removeOrganizationalUnit(space.getName()));
    }

    protected boolean isOldPlayground(OrganizationalUnit ou) {
        return ou.getName().startsWith(PREFIX) && !ou.getName().endsWith(this.md5);
    }

    protected void createPlaygroundHiddenSpace(String md5) {
        String spaceName = PREFIX + md5;
        this.ouService.createOrganizationalUnit(spaceName, DEFAULT_GROUP_ID);
    }

    protected void deleteOldPlaygrounds(String md5) {
        try {
            Files.list(this.playgroundRootDirectory.toPath()).filter(p -> !p.toFile().getAbsolutePath().endsWith(md5)).forEach(this::cleanPlaygroundDirectory);
        }
        catch (Exception e) {
            throw new ImportExamplesException("Can't delete old playgrounds", e);
        }
    }

    protected String calculateMD5(URL resource) {
        String string;
        block8: {
            InputStream is = resource.openStream();
            try {
                string = DigestUtils.md5Hex((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ImportExamplesException("Can't calculate md5 for playground.zip", e);
                }
            }
            is.close();
        }
        return string;
    }

    private void cleanPlaygroundDirectory(Path playgroundDirectoryPath) {
        try {
            Files.walkFileTree(playgroundDirectoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    file.toFile().delete();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    dir.toFile().delete();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            throw new ImportExamplesException("Can't delete playground directory: " + playgroundDirectoryPath.toFile().getName(), e);
        }
    }

    protected String resolveRepositoryUrl(String playgroundDirectoryPath) {
        if ("\\".equals(this.getFileSeparator())) {
            return "file:///" + playgroundDirectoryPath.replaceAll("\\\\", "/");
        }
        return "file://" + playgroundDirectoryPath;
    }

    public ExamplesMetaData getMetaData() {
        return new ExamplesMetaData(this.getPlaygroundRepository());
    }

    public ExampleRepository getPlaygroundRepository() {
        return this.playgroundRepository;
    }

    @Override
    protected Repository resolveGitRepository(ExampleRepository exampleRepository) {
        return (Repository)this.spaceConfigStorageRegistry.getBatch(this.playgroundSpaceName).run(spaceConfigStorageBatchContext -> {
            if (exampleRepository.equals((Object)this.playgroundRepository)) {
                return (Repository)this.ouService.getOrganizationalUnit(this.playgroundSpaceName).getRepositories().stream().findFirst().get();
            }
            Credentials credentials = exampleRepository.getCredentials();
            String username = null;
            String password = null;
            if (credentials != null) {
                username = credentials.getUsername();
                password = credentials.getPassword();
            }
            return this.cloneRepository(exampleRepository.getUrl(), username, password);
        });
    }

    private Repository cloneRepository(String repositoryURL) {
        return this.cloneRepository(repositoryURL, null, null);
    }

    private Repository cloneRepository(String repositoryURL, String userName, String password) {
        try {
            String alias = this.getRepositoryAlias(repositoryURL);
            Map<String, Object> env = this.buildGitEnv(repositoryURL, userName, password, false);
            RepositoryInfo repositoryConfig = this.createConfigGroup(alias, env);
            Repository repository = this.repositoryFactory.newRepository(repositoryConfig);
            this.ouService.addRepository(this.ouService.getOrganizationalUnit(this.playgroundSpaceName), repository);
            return repository;
        }
        catch (Exception e) {
            logger.error("Error during create repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getDefaultSpace() {
        return this.playgroundSpaceName;
    }

    @Override
    protected String getRepositoryAlias(String repositoryURL) {
        return "examples-" + super.getRepositoryAlias(repositoryURL);
    }

    String getFileSeparator() {
        return FileSystems.getDefault().getSeparator();
    }

    public WorkspaceProjectContextChangeEvent setupExamples(ExampleOrganizationalUnit exampleTargetOU, List<ImportProject> importProjects) {
        PortablePreconditions.checkNotNull((String)"exampleTargetOU", (Object)exampleTargetOU);
        PortablePreconditions.checkNotNull((String)"exampleProjects", importProjects);
        PortablePreconditions.checkCondition((String)"Must have at least one ExampleProject", (importProjects.size() > 0 ? 1 : 0) != 0);
        String targetOUName = exampleTargetOU.getName();
        OrganizationalUnit targetOU = this.getOrganizationalUnit(targetOUName);
        return this.importProjects(targetOU, importProjects);
    }

    public Set<ImportProject> getExampleProjects(OrganizationalUnit targetOu) {
        ExampleRepository repos = this.getPlaygroundRepository();
        return this.getProjects(targetOu, repos);
    }

    protected OrganizationalUnit getOrganizationalUnit(String targetOUName) {
        OrganizationalUnit targetOU = this.ouService.getOrganizationalUnit(targetOUName);
        if (targetOU == null) {
            targetOU = this.createOrganizationalUnit(targetOUName);
        }
        return targetOU;
    }

    protected OrganizationalUnit createOrganizationalUnit(String name) {
        OrganizationalUnit ou = this.ouService.createOrganizationalUnit(name, "");
        return ou;
    }

    public int priority() {
        return 0;
    }

    public void dispose() {
    }

    void setPlaygroundRepository(ExampleRepository playgroundRepository) {
        this.playgroundRepository = playgroundRepository;
    }

    protected boolean existSpace(String space) {
        return this.existSpace(space, this.getNiogitPath());
    }

    protected boolean existSpace(String space, Path path) {
        try {
            DirectoryStream<Path> spaces = Files.newDirectoryStream(path);
            return StreamSupport.stream(spaces.spliterator(), false).filter(s -> s.getFileName().toString().equalsIgnoreCase(space)).findFirst().isPresent();
        }
        catch (Exception e) {
            throw new ImportExamplesException("Can't read spaces directory", e);
        }
    }

    protected Path getNiogitPath() {
        JGitPathImpl systemGitPath = (JGitPathImpl)this.systemFS.getPath("system", new String[0]);
        return ((JGitFileSystem)systemGitPath.getFileSystem()).getGit().getRepository().getDirectory().getParentFile().getParentFile().toPath();
    }
}

