/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.base;

import java.io.File;
import java.net.URI;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.StringAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.commons.java.nio.base.GeneralPathImpl;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.spi.FileSystemProvider;
import org.mockito.Mockito;

public class GeneralPathTest {
    private static final String DEFAULT_PATH = new File("").getAbsolutePath() + "/";
    final FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);

    @Test
    public void testSimpleAbsoluteUnix() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((Iterable)path.toAbsolutePath()).isEqualTo((Object)path);
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/path/to/file.txt");
        ((ObjectAssert)Assertions.assertThat((Object)path.getFileSystem()).isNotNull()).isEqualTo((Object)this.fs);
        Assertions.assertThat((Iterable)path.getFileName()).isNotNull();
        Assertions.assertThat((String)path.getFileName().toString()).isEqualTo((Object)"file.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(3);
        Assertions.assertThat((Iterable)path.getName(0)).isNotNull();
        Assertions.assertThat((String)path.getName(0).toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.getName(1)).isNotNull();
        Assertions.assertThat((String)path.getName(1).toString()).isEqualTo((Object)"to");
        ((IterableAssert)Assertions.assertThat((Iterable)path.getName(2)).isNotNull()).isEqualTo((Object)path.getFileName());
        Assertions.assertThat((Iterable)path.subpath(0, 1)).isNotNull();
        Assertions.assertThat((String)path.subpath(0, 1).toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.subpath(1, 2)).isNotNull();
        Assertions.assertThat((String)path.subpath(1, 2).toString()).isEqualTo((Object)"to");
        Assertions.assertThat((Iterable)path.subpath(0, 2)).isNotNull();
        Assertions.assertThat((String)path.subpath(0, 2).toString()).isEqualTo((Object)"path/to");
        Assertions.assertThat((Iterable)path.subpath(1, 3)).isNotNull();
        Assertions.assertThat((String)path.subpath(1, 3).toString()).isEqualTo((Object)"to/file.txt");
        int i = 0;
        for (Path currentPath : path) {
            Assertions.assertThat((Iterable)currentPath).isEqualTo((Object)path.getName(i));
            ++i;
        }
        Assertions.assertThat((Iterable)path.getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().toString()).isEqualTo((Object)"/path/to");
        Assertions.assertThat((Iterable)path.getParent().getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().getParent().toString()).isEqualTo((Object)"/path");
        Assertions.assertThat((Iterable)path.getParent().getParent().getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().getParent().getParent().toString()).isEqualTo((Object)"/");
        Assertions.assertThat((Iterable)path.getRoot().getParent()).isNull();
        Assertions.assertThat((Iterable)path.getRoot()).isNotNull();
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"/");
    }

    @Test
    public void testSimpleRootUnix() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"/");
        Assertions.assertThat((Iterable)path.getFileName()).isNull();
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(0);
        ((IterableAssert)Assertions.assertThat((Iterable)path.getRoot()).isNotNull()).isEqualTo((Object)path);
        try {
            path.getName(0);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void startsWith() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/p/th/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/some/other/path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"to", (boolean)false)));
    }

    @Test
    public void endsWith() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"file.txt", (boolean)false)));
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"to/file.txt", (boolean)false)));
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"filename.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/some/other/path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"txt", (boolean)false)));
    }

    @Test
    public void testSimpleRelativeUnix() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"path/to/file.txt");
        ((ObjectAssert)Assertions.assertThat((Object)path.getFileSystem()).isNotNull()).isEqualTo((Object)this.fs);
        Assertions.assertThat((Iterable)path.getFileName()).isNotNull();
        Assertions.assertThat((String)path.getFileName().toString()).isEqualTo((Object)"file.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(3);
        Assertions.assertThat((Iterable)path.getName(0)).isNotNull();
        Assertions.assertThat((String)path.getName(0).toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.getName(1)).isNotNull();
        Assertions.assertThat((String)path.getName(1).toString()).isEqualTo((Object)"to");
        ((IterableAssert)Assertions.assertThat((Iterable)path.getName(2)).isNotNull()).isEqualTo((Object)path.getFileName());
        Assertions.assertThat((Iterable)path.subpath(0, 1)).isNotNull();
        Assertions.assertThat((String)path.subpath(0, 1).toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.subpath(1, 2)).isNotNull();
        Assertions.assertThat((String)path.subpath(1, 2).toString()).isEqualTo((Object)"to");
        Assertions.assertThat((Iterable)path.subpath(0, 2)).isNotNull();
        Assertions.assertThat((String)path.subpath(0, 2).toString()).isEqualTo((Object)"path/to");
        Assertions.assertThat((Iterable)path.subpath(1, 3)).isNotNull();
        Assertions.assertThat((String)path.subpath(1, 3).toString()).isEqualTo((Object)"to/file.txt");
        int i = 0;
        for (Path currentPath : path) {
            Assertions.assertThat((Iterable)currentPath).isEqualTo((Object)path.getName(i));
            ++i;
        }
        Assertions.assertThat((Iterable)path.getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().toString()).isEqualTo((Object)"path/to");
        Assertions.assertThat((Iterable)path.getParent().getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().getParent().toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.getParent().getParent().getParent()).isNull();
        Assertions.assertThat((Iterable)path.getRoot()).isNull();
        Assertions.assertThat((Iterable)path.toAbsolutePath()).isNotNull();
        Assertions.assertThat((String)path.toAbsolutePath().toString()).isEqualTo((Object)(DEFAULT_PATH + "path/to/file.txt"));
    }

    @Test
    public void testSimpleAbsoluteWindows() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\file.txt", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((Iterable)path.toAbsolutePath()).isEqualTo((Object)path);
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"c:\\path\\to\\file.txt");
        ((ObjectAssert)Assertions.assertThat((Object)path.getFileSystem()).isNotNull()).isEqualTo((Object)this.fs);
        Assertions.assertThat((Iterable)path.getFileName()).isNotNull();
        Assertions.assertThat((String)path.getFileName().toString()).isEqualTo((Object)"file.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(3);
        Assertions.assertThat((Iterable)path.getName(0)).isNotNull();
        Assertions.assertThat((String)path.getName(0).toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.getName(1)).isNotNull();
        Assertions.assertThat((String)path.getName(1).toString()).isEqualTo((Object)"to");
        ((IterableAssert)Assertions.assertThat((Iterable)path.getName(2)).isNotNull()).isEqualTo((Object)path.getFileName());
        Assertions.assertThat((Iterable)path.subpath(0, 1)).isNotNull();
        Assertions.assertThat((String)path.subpath(0, 1).toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.subpath(1, 2)).isNotNull();
        Assertions.assertThat((String)path.subpath(1, 2).toString()).isEqualTo((Object)"to");
        Assertions.assertThat((Iterable)path.subpath(0, 2)).isNotNull();
        Assertions.assertThat((String)path.subpath(0, 2).toString()).isEqualTo((Object)"path\\to");
        Assertions.assertThat((Iterable)path.subpath(1, 3)).isNotNull();
        Assertions.assertThat((String)path.subpath(1, 3).toString()).isEqualTo((Object)"to\\file.txt");
        int i = 0;
        for (Path currentPath : path) {
            Assertions.assertThat((Iterable)currentPath).isEqualTo((Object)path.getName(i));
            ++i;
        }
        Assertions.assertThat((Iterable)path.getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().toString()).isEqualTo((Object)"c:\\path\\to");
        Assertions.assertThat((Iterable)path.getParent().getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().getParent().toString()).isEqualTo((Object)"c:\\path");
        Assertions.assertThat((Iterable)path.getParent().getParent().getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().getParent().getParent().toString()).isEqualTo((Object)"c:\\");
        Assertions.assertThat((Iterable)path.getRoot().getParent()).isNull();
        Assertions.assertThat((Iterable)path.getRoot()).isNotNull();
        ((StringAssert)Assertions.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo((Object)"c:\\");
    }

    @Test
    public void testSimpleRootWindows() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"c:\\");
        Assertions.assertThat((Iterable)path.getFileName()).isNull();
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(0);
        ((IterableAssert)Assertions.assertThat((Iterable)path.getRoot()).isNotNull()).isEqualTo((Object)path);
        try {
            path.getName(0);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testSimpleRelativeWindows() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\file.txt", (boolean)false);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((boolean)path.isAbsolute()).isFalse();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)"path\\to\\file.txt");
        ((ObjectAssert)Assertions.assertThat((Object)path.getFileSystem()).isNotNull()).isEqualTo((Object)this.fs);
        Assertions.assertThat((Iterable)path.getFileName()).isNotNull();
        Assertions.assertThat((String)path.getFileName().toString()).isEqualTo((Object)"file.txt");
        Assertions.assertThat((int)path.getNameCount()).isEqualTo(3);
        Assertions.assertThat((Iterable)path.getName(0)).isNotNull();
        Assertions.assertThat((String)path.getName(0).toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.getName(1)).isNotNull();
        Assertions.assertThat((String)path.getName(1).toString()).isEqualTo((Object)"to");
        ((IterableAssert)Assertions.assertThat((Iterable)path.getName(2)).isNotNull()).isEqualTo((Object)path.getFileName());
        Assertions.assertThat((Iterable)path.subpath(0, 1)).isNotNull();
        Assertions.assertThat((String)path.subpath(0, 1).toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.subpath(1, 2)).isNotNull();
        Assertions.assertThat((String)path.subpath(1, 2).toString()).isEqualTo((Object)"to");
        Assertions.assertThat((Iterable)path.subpath(0, 2)).isNotNull();
        Assertions.assertThat((String)path.subpath(0, 2).toString()).isEqualTo((Object)"path\\to");
        Assertions.assertThat((Iterable)path.subpath(1, 3)).isNotNull();
        Assertions.assertThat((String)path.subpath(1, 3).toString()).isEqualTo((Object)"to\\file.txt");
        int i = 0;
        for (Path currentPath : path) {
            Assertions.assertThat((Iterable)currentPath).isEqualTo((Object)path.getName(i));
            ++i;
        }
        Assertions.assertThat((Iterable)path.getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().toString()).isEqualTo((Object)"path\\to");
        Assertions.assertThat((Iterable)path.getParent().getParent()).isNotNull();
        Assertions.assertThat((String)path.getParent().getParent().toString()).isEqualTo((Object)"path");
        Assertions.assertThat((Iterable)path.getParent().getParent().getParent()).isNull();
        Assertions.assertThat((Iterable)path.toAbsolutePath()).isNotNull();
        Assertions.assertThat((String)path.toAbsolutePath().toString()).isEqualTo((Object)("C:" + DEFAULT_PATH.replaceAll("/", "\\\\") + "path\\to\\file.txt"));
        Assertions.assertThat((Iterable)path.getRoot()).isNull();
    }

    @Test
    public void testToFile() throws Exception {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        File file = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)this.fs, (File)file);
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((String)path.toString()).isEqualTo((Object)file.getAbsolutePath());
        Assertions.assertThat((File)path.toFile()).isEqualTo((Object)file);
    }

    @Test
    public void testAbsloluteSimpleToURIUnix() throws Exception {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        URI uri = path.toUri();
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((Object)uri).isNotNull();
        Assertions.assertThat((String)uri.toString()).isEqualTo((Object)"file:///path/to/file.txt");
    }

    @Test
    public void testAbsoluteToURIUnix() throws Exception {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        URI uri = path.toUri();
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((Object)uri).isNotNull();
        Assertions.assertThat((String)uri.toString()).isEqualTo((Object)"default:///path/to/file.txt");
        Path realPath = path.toRealPath(new LinkOption[0]);
        Assertions.assertThat((Iterable)realPath).isNotNull();
        Assertions.assertThat((Iterable)realPath.toRealPath(new LinkOption[0])).isEqualTo((Object)realPath);
        Assertions.assertThat((Object)realPath.toUri()).isNotNull();
        Assertions.assertThat((String)realPath.toUri().toString()).isEqualTo((Object)"file:///path/to/file.txt");
    }

    @Test
    public void testRelativeToURIUnix() throws Exception {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false);
        URI uri = path.toUri();
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((Object)uri).isNotNull();
        Assertions.assertThat((String)uri.toString()).isEqualTo((Object)("default://" + DEFAULT_PATH + "path/to/file.txt"));
        Assertions.assertThat((String)path.toRealPath(new LinkOption[0]).toUri().toString()).isEqualTo((Object)("file://" + DEFAULT_PATH + "path/to/file.txt"));
    }

    @Test
    public void testAbsoluteToURIWindows() throws Exception {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\file.txt", (boolean)false);
        URI uri = path.toUri();
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((Object)uri).isNotNull();
        Assertions.assertThat((String)uri.toString()).isEqualTo((Object)"default:///c:/path/to/file.txt");
        Path realPath = path.toRealPath(new LinkOption[0]);
        Assertions.assertThat((Iterable)realPath).isNotNull();
        Assertions.assertThat((Iterable)realPath.toRealPath(new LinkOption[0])).isEqualTo((Object)realPath);
        Assertions.assertThat((Object)realPath.toUri()).isNotNull();
        Assertions.assertThat((String)realPath.toUri().toString()).isEqualTo((Object)"file:///c:/path/to/file.txt");
    }

    @Test
    public void testRelativeToURIWindows() throws Exception {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\file.txt", (boolean)false);
        URI uri = path.toUri();
        Assertions.assertThat((Iterable)path).isNotNull();
        Assertions.assertThat((Object)uri).isNotNull();
        Assertions.assertThat((String)uri.toString()).isEqualTo((Object)("default:///C:" + DEFAULT_PATH + "path/to/file.txt"));
        Assertions.assertThat((String)path.toRealPath(new LinkOption[0]).toUri().toString()).isEqualTo((Object)("file:///C:" + DEFAULT_PATH + "path/to/file.txt"));
    }

    @Test
    public void testResolve() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        Path resolvedPath = path.resolve("some/file.text");
        Assertions.assertThat((Iterable)resolvedPath).isNotNull();
        Assertions.assertThat((String)resolvedPath.toString()).isEqualTo((Object)"/path/to/some/file.text");
        Path resolvedPath2 = path.resolve("/some/file.text");
        Assertions.assertThat((Iterable)resolvedPath2).isNotNull();
        Assertions.assertThat((String)resolvedPath2.toString()).isEqualTo((Object)"/some/file.text");
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path resolvedPath3 = path2.resolve("/some/file.text");
        Assertions.assertThat((Iterable)resolvedPath3).isNotNull();
        Assertions.assertThat((String)resolvedPath3.toString()).isEqualTo((Object)"/some/file.text");
        Path resolvedPath4 = path2.resolve("some/file.text");
        Assertions.assertThat((Iterable)resolvedPath4).isNotNull();
        Assertions.assertThat((String)resolvedPath4.toString()).isEqualTo((Object)"/path/to/some/file.text");
        Path resolvedPath5 = path2.resolve("");
        Assertions.assertThat((Iterable)resolvedPath5).isNotNull();
        Assertions.assertThat((String)resolvedPath5.toString()).isEqualTo((Object)path2.toString());
        Assertions.assertThat((Iterable)resolvedPath5).isEqualTo((Object)path2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkResolveNull() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        path.resolve((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkResolveNull2() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        path.resolve((Path)null);
    }

    @Test
    public void testNormalize() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        ((IterableAssert)Assertions.assertThat((Iterable)path.normalize()).isNotNull()).isEqualTo((Object)path);
        ((IterableAssert)Assertions.assertThat((Iterable)path.normalize().normalize()).isNotNull()).isEqualTo((Object)path.normalize());
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/some/path/../../to", (boolean)false);
        Assertions.assertThat((Iterable)path2.normalize()).isNotNull();
        Assertions.assertThat((String)path2.normalize().toString()).isEqualTo((Object)"/to");
        ((IterableAssert)Assertions.assertThat((Iterable)path2.normalize().normalize()).isNotNull()).isEqualTo((Object)path2.normalize());
    }

    @Test
    public void testNormalizeWindows() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\", (boolean)false);
        ((IterableAssert)Assertions.assertThat((Iterable)path.normalize()).isNotNull()).isEqualTo((Object)path);
        ((IterableAssert)Assertions.assertThat((Iterable)path.normalize().normalize()).isNotNull()).isEqualTo((Object)path.normalize());
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\some\\path\\..\\..\\to", (boolean)false);
        Assertions.assertThat((Iterable)path2.normalize()).isNotNull();
        Assertions.assertThat((String)path2.normalize().toString()).isEqualTo((Object)"c:\\to");
        ((IterableAssert)Assertions.assertThat((Iterable)path2.normalize().normalize()).isNotNull()).isEqualTo((Object)path2.normalize());
    }

    @Test
    public void testResolveSibling() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        Path resolvedPath = path.resolveSibling("some/file.text");
        Assertions.assertThat((Iterable)resolvedPath).isNotNull();
        Assertions.assertThat((String)resolvedPath.toString()).isEqualTo((Object)"/path/some/file.text");
        Path resolvedPath2 = path.resolveSibling("/some/file.text");
        Assertions.assertThat((Iterable)resolvedPath2).isNotNull();
        Assertions.assertThat((String)resolvedPath2.toString()).isEqualTo((Object)"/some/file.text");
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path resolvedPath3 = path2.resolveSibling("/some/file.text");
        Assertions.assertThat((Iterable)resolvedPath3).isNotNull();
        Assertions.assertThat((String)resolvedPath3.toString()).isEqualTo((Object)"/some/file.text");
        Path resolvedPath4 = path2.resolveSibling("some/file.text");
        Assertions.assertThat((Iterable)resolvedPath4).isNotNull();
        Assertions.assertThat((String)resolvedPath4.toString()).isEqualTo((Object)"/path/some/file.text");
        Path resolvedPath5 = path2.resolveSibling("");
        Assertions.assertThat((Iterable)resolvedPath5).isNotNull();
        Assertions.assertThat((String)resolvedPath5.toString()).isEqualTo((Object)path2.getParent().toString());
        Assertions.assertThat((Iterable)resolvedPath5).isEqualTo((Object)path2.getParent());
    }

    @Test
    public void testRelativize() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/some/place", (boolean)false);
        Path relative = path.relativize((Path)other);
        Assertions.assertThat((Iterable)relative).isNotNull();
        Assertions.assertThat((String)relative.toString()).isEqualTo((Object)"some/place");
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/some/place", (boolean)false);
        GeneralPathImpl other2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path relative2 = path2.relativize((Path)other2);
        Assertions.assertThat((Iterable)relative2).isNotNull();
        Assertions.assertThat((String)relative2.toString()).isEqualTo((Object)"../..");
        GeneralPathImpl path3 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        GeneralPathImpl other3 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path relative3 = path3.relativize((Path)other3);
        Assertions.assertThat((Iterable)relative3).isNotNull();
        Assertions.assertThat((String)relative3.toString()).isEqualTo((Object)"");
        GeneralPathImpl path4 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        GeneralPathImpl other4 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/some/place", (boolean)false);
        Path relative4 = path4.relativize((Path)other4);
        Assertions.assertThat((Iterable)relative4).isNotNull();
        Assertions.assertThat((String)relative4.toString()).isEqualTo((Object)"some/place");
        GeneralPathImpl path5 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        GeneralPathImpl other5 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        Path relative5 = path5.relativize((Path)other5);
        Assertions.assertThat((Iterable)relative5).isNotNull();
        Assertions.assertThat((String)relative5.toString()).isEqualTo((Object)"../../some/place");
        GeneralPathImpl path6 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        GeneralPathImpl other6 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        Path relative6 = path6.relativize((Path)other6);
        Assertions.assertThat((Iterable)relative6).isNotNull();
        Assertions.assertThat((String)relative6.toString()).isEqualTo((Object)"../../path/to");
        GeneralPathImpl path7 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/some/thing/here", (boolean)false);
        GeneralPathImpl other7 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        Path relative7 = path7.relativize((Path)other7);
        Assertions.assertThat((Iterable)relative7).isNotNull();
        Assertions.assertThat((String)relative7.toString()).isEqualTo((Object)"../../../../../some/place");
        GeneralPathImpl path8 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        GeneralPathImpl other8 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/some/thing/here", (boolean)false);
        Path relative8 = path8.relativize((Path)other8);
        Assertions.assertThat((Iterable)relative8).isNotNull();
        Assertions.assertThat((String)relative8.toString()).isEqualTo((Object)"../../path/to/some/thing/here");
        GeneralPathImpl path9 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        GeneralPathImpl other9 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path relative9 = path9.relativize((Path)other9);
        Assertions.assertThat((Iterable)relative9).isNotNull();
        Assertions.assertThat((String)relative9.toString()).isEqualTo((Object)"");
        GeneralPathImpl path10 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        GeneralPathImpl other10 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        Path relative10 = path10.relativize((Path)other10);
        Assertions.assertThat((Iterable)relative10).isNotNull();
        Assertions.assertThat((String)relative10.toString()).isEqualTo((Object)"");
        GeneralPathImpl path11 = GeneralPathImpl.create((FileSystem)this.fs, (String)"", (boolean)false);
        GeneralPathImpl other11 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        Path relative11 = path11.relativize((Path)other11);
        ((IterableAssert)Assertions.assertThat((Iterable)relative11).isNotNull()).isEqualTo((Object)other11);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeIlegal1() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        path.relativize((Path)other);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeIlegal2() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        path.relativize((Path)other);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeIlegal3() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        path.relativize((Path)other);
    }

    @Test
    public void testRelativizeWindows() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\place", (boolean)false);
        Path relative = path.relativize((Path)other);
        Assertions.assertThat((Iterable)relative).isNotNull();
        Assertions.assertThat((String)relative.toString()).isEqualTo((Object)"some\\place");
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\place", (boolean)false);
        GeneralPathImpl other2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        Path relative2 = path2.relativize((Path)other2);
        Assertions.assertThat((Iterable)relative2).isNotNull();
        Assertions.assertThat((String)relative2.toString()).isEqualTo((Object)"..\\..");
        GeneralPathImpl path3 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path/to", (boolean)false);
        GeneralPathImpl other3 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path/to", (boolean)false);
        Path relative3 = path3.relativize((Path)other3);
        Assertions.assertThat((Iterable)relative3).isNotNull();
        Assertions.assertThat((String)relative3.toString()).isEqualTo((Object)"");
        GeneralPathImpl path4 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        GeneralPathImpl other4 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\some\\place", (boolean)false);
        Path relative4 = path4.relativize((Path)other4);
        Assertions.assertThat((Iterable)relative4).isNotNull();
        Assertions.assertThat((String)relative4.toString()).isEqualTo((Object)"some\\place");
        GeneralPathImpl path5 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        GeneralPathImpl other5 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        Path relative5 = path5.relativize((Path)other5);
        Assertions.assertThat((Iterable)relative5).isNotNull();
        Assertions.assertThat((String)relative5.toString()).isEqualTo((Object)"..\\..\\some\\place");
        GeneralPathImpl path6 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        GeneralPathImpl other6 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        Path relative6 = path6.relativize((Path)other6);
        Assertions.assertThat((Iterable)relative6).isNotNull();
        Assertions.assertThat((String)relative6.toString()).isEqualTo((Object)"..\\..\\path\\to");
        GeneralPathImpl path7 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\some\\thing\\here", (boolean)false);
        GeneralPathImpl other7 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        Path relative7 = path7.relativize((Path)other7);
        Assertions.assertThat((Iterable)relative7).isNotNull();
        Assertions.assertThat((String)relative7.toString()).isEqualTo((Object)"..\\..\\..\\..\\..\\some\\place");
        GeneralPathImpl path8 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        GeneralPathImpl other8 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\some\\thing\\here", (boolean)false);
        Path relative8 = path8.relativize((Path)other8);
        Assertions.assertThat((Iterable)relative8).isNotNull();
        Assertions.assertThat((String)relative8.toString()).isEqualTo((Object)"..\\..\\path\\to\\some\\thing\\here");
        GeneralPathImpl path9 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        GeneralPathImpl other9 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        Path relative9 = path9.relativize((Path)other9);
        Assertions.assertThat((Iterable)relative9).isNotNull();
        Assertions.assertThat((String)relative9.toString()).isEqualTo((Object)"");
        GeneralPathImpl path10 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        GeneralPathImpl other10 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        Path relative10 = path10.relativize((Path)other10);
        Assertions.assertThat((Iterable)relative10).isNotNull();
        Assertions.assertThat((String)relative10.toString()).isEqualTo((Object)"");
        GeneralPathImpl path11 = GeneralPathImpl.create((FileSystem)this.fs, (String)"", (boolean)false);
        GeneralPathImpl other11 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        Path relative11 = path11.relativize((Path)other11);
        ((IterableAssert)Assertions.assertThat((Iterable)relative11).isNotNull()).isEqualTo((Object)other11);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeWindowsIllegal1() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        path.relativize((Path)other);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeWindowsIllegal2() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        path.relativize((Path)other);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeWindowsIllegal3() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        path.relativize((Path)other);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRelativizeWindowsIllegal4() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"d:\\path\\to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        path.relativize((Path)other);
    }
}

