/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.base;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.commons.java.nio.base.GeneralPathImpl;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.WatchEvent;
import org.kie.commons.java.nio.file.WatchService;
import org.mockito.Mockito;

public class GeneralPathUnsupportedOpsTest {
    final FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
    final WatchService ws = (WatchService)Mockito.mock(WatchService.class);
    final WatchEvent.Kind kd = (WatchEvent.Kind)Mockito.mock(WatchEvent.Kind.class);
    final WatchEvent.Modifier mf = (WatchEvent.Modifier)Mockito.mock(WatchEvent.Modifier.class);
    Path param;

    @Before
    public void setup() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        this.param = GeneralPathImpl.create((FileSystem)this.fs, (String)"path", (boolean)false);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void compareTo() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.compareTo((Object)this.param);
    }

    @Test(expected=UnsupportedOperationException.class)
    @Ignore
    public void register() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.register(this.ws, new WatchEvent.Kind[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    @Ignore
    public void register2() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.register(this.ws, new WatchEvent.Kind[]{this.kd}, new WatchEvent.Modifier[]{this.mf});
    }
}

