/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.base;

import java.io.File;
import org.junit.Before;
import org.junit.Test;
import org.kie.commons.java.nio.base.GeneralPathImpl;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.Path;
import org.mockito.Mockito;

public class GeneralPathValidationTest {
    final FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createNull1() {
        GeneralPathImpl.create(null, (String)"/path/to/file.txt", (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createNull2() {
        GeneralPathImpl.create((FileSystem)this.fs, null, (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFromFileNull1() {
        GeneralPathImpl.newFromFile(null, (File)new File(""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void newFromFileNull2() {
        GeneralPathImpl.newFromFile((FileSystem)this.fs, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNameNegative() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.getName(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathInvaligRange1() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.subpath(-1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathInvaligRange2() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.subpath(5, 7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathInvaligRange3() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.subpath(0, 7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathInvaligRange4() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.subpath(2, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void startsWith() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.startsWith((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void startsWithPath() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.startsWith((Path)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void endsWith() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.endsWith((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void endsWithPath() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.endsWith((Path)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolve() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.resolve((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolvePath() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.resolve((Path)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveSibling() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.resolveSibling((String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveSiblingPath() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.resolveSibling((Path)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void relativize() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.relativize(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void compareTo() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.compareTo(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkEquals() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        path.equals(null);
    }
}

