/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.base;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.kie.commons.java.nio.base.SeekableByteChannelFileBasedImpl;

public class SeekableByteChannelTest {
    @Test
    public void test() throws IOException {
        File tempFile = File.createTempFile("foo", "bar");
        SeekableByteChannelFileBasedImpl sbc = new SeekableByteChannelFileBasedImpl(new RandomAccessFile(tempFile, "rw").getChannel());
        Assert.assertTrue((boolean)sbc.isOpen());
        sbc.write(ByteBuffer.wrap("CONTENT\n?!".getBytes()));
        sbc.position(0L);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        sbc.read(buffer);
        Assert.assertEquals((Object)"CONTENT\n?!", (Object)new String(buffer.array()));
        sbc.close();
        Assert.assertFalse((boolean)sbc.isOpen());
    }

    @Test
    public void testPosition() throws IOException {
        File tempFile = File.createTempFile("foo", "bar");
        SeekableByteChannelFileBasedImpl sbc = new SeekableByteChannelFileBasedImpl(new RandomAccessFile(tempFile, "rw").getChannel());
        Assert.assertTrue((boolean)sbc.isOpen());
        sbc.write(ByteBuffer.wrap("CONTENT\n?!".getBytes()));
        Assert.assertEquals((long)10L, (long)sbc.position());
        Assert.assertEquals((long)10L, (long)sbc.size());
        sbc.position(1L);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        sbc.read(buffer);
        Assert.assertEquals((Object)"ONTENT\n?", (Object)new String(buffer.array()));
        Assert.assertEquals((long)9L, (long)sbc.position());
        sbc.position(0L);
        sbc.truncate(2L);
        ByteBuffer buffer3 = ByteBuffer.allocate(2);
        sbc.read(buffer3);
        Assert.assertEquals((Object)"CO", (Object)new String(buffer3.array()));
        sbc.close();
        Assert.assertFalse((boolean)sbc.isOpen());
    }
}

