/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.timer.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.core.ClockType;
import org.drools.core.time.SessionPseudoClock;
import org.drools.persistence.util.PersistenceUtil;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.infinispan.InfinispanKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class TimerAndCalendarTest {
    private DefaultCacheManager cm;
    private HashMap<String, Object> context;

    @Test
    public void testTimerRuleAfterIntReloadSession() throws Exception {
        KieBaseConfiguration kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbaseConf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbaseConf);
        StatefulKnowledgeSession ksession = this.createSession((KieBase)kbase);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        String timerRule = "package org.drools.test\nglobal java.util.List list \nrule TimerRule \n   timer (int:1000 500) \nwhen \nthen \n        list.add(list.size()); \n end";
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        List list = Collections.synchronizedList(new ArrayList());
        ksession.setGlobal("list", list);
        Assert.assertEquals((long)0L, (long)list.size());
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1700L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1000L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testTimerRuleAfterCronReloadSession() throws Exception {
        KieBaseConfiguration kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbaseConf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbaseConf);
        StatefulKnowledgeSession ksession = this.createSession((KieBase)kbase);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        String timerRule = "package org.drools.test\nglobal java.util.List list \nrule TimerRule \n   timer (cron: * * * * * ?) \nwhen \nthen \n        list.add(list.size()); \n end";
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        List list = Collections.synchronizedList(new ArrayList());
        ksession.setGlobal("list", list);
        ksession.setGlobal("list", list);
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession.setGlobal("list", list);
        clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(2L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testEventExpires() throws Exception {
        String timerRule = "package org.drools.test\ndeclare TestEvent \n    @role( event )\n    @expires( 10s )\nend\nrule TimerRule \n    when \n        TestEvent( ) from entry-point \"Test\"\n    then \nend";
        KieBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbconf);
        Resource resource = ResourceFactory.newByteArrayResource((byte[])timerRule.getBytes());
        Collection<KnowledgePackage> kpackages = this.buildKnowledgePackage(resource, ResourceType.DRL);
        kbase.addKnowledgePackages(kpackages);
        StatefulKnowledgeSession ksession = this.createSession((KieBase)kbase);
        FactType type = kbase.getFactType("org.drools.test", "TestEvent");
        Assert.assertNotNull((String)"could not get type", (Object)type);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession.getEntryPoint("Test").insert(type.newInstance());
        ksession.fireAllRules();
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
        ksession = this.disposeAndReloadSession(ksession, (KieBase)kbase);
    }

    @Before
    public void before() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("drools-configured-cache");
        this.cm = (DefaultCacheManager)this.context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
    }

    @After
    public void after() throws Exception {
        PersistenceUtil.tearDown(this.context);
    }

    private StatefulKnowledgeSession createSession(KieBase kbase) {
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = InfinispanKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, (KieSessionConfiguration)conf, (Environment)PersistenceUtil.createEnvironment(this.context));
        return ksession;
    }

    private StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, KieBase kbase) {
        long ksessionId = ksession.getIdentifier();
        ksession.dispose();
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession newksession = InfinispanKnowledgeService.loadStatefulKnowledgeSession((long)ksessionId, (KieBase)kbase, (KieSessionConfiguration)conf, (Environment)PersistenceUtil.createEnvironment(this.context));
        return newksession;
    }

    private Collection<KnowledgePackage> buildKnowledgePackage(Resource resource, ResourceType resourceType) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(resource, resourceType);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors != null && errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println("Error: " + error.getMessage());
            }
            Assert.fail((String)"KnowledgeBase did not build");
        }
        Collection packages = kbuilder.getKnowledgePackages();
        return packages;
    }
}

