/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.infinispan;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.command.CommandService;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJob;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobInstance;
import org.drools.persistence.infinispan.InfinispanTimerJobInstance;

public class InfinispanTimeJobFactoryManager
implements TimerJobFactoryManager {
    private CommandService commandService;
    private Map<Integer, Map<Long, TimerJobInstance>> timerInstances = new ConcurrentHashMap<Integer, Map<Long, TimerJobInstance>>();
    private Map<Long, TimerJobInstance> singleTimerInstances = new ConcurrentHashMap<Long, TimerJobInstance>();

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public TimerJobInstance createTimerJobInstance(Job job, JobContext ctx, Trigger trigger, JobHandle handle, InternalSchedulerService scheduler) {
        Map<Long, TimerJobInstance> local = null;
        if (this.hasMethod(ctx.getClass(), "sessionId")) {
            int sessionId = this.getMethodIntValue(ctx, "getSessionId");
            Map<Long, TimerJobInstance> instances = this.timerInstances.get(sessionId);
            if (instances == null) {
                instances = new ConcurrentHashMap<Long, TimerJobInstance>();
                this.timerInstances.put(sessionId, instances);
            }
            local = this.timerInstances.get(sessionId);
        } else {
            local = this.singleTimerInstances;
        }
        ctx.setJobHandle(handle);
        InfinispanTimerJobInstance jobInstance = new InfinispanTimerJobInstance((Job)new SelfRemovalJob(job), (JobContext)new SelfRemovalJobContext(ctx, local), trigger, handle, scheduler);
        return jobInstance;
    }

    public void addTimerJobInstance(TimerJobInstance instance) {
        JobContext ctx = instance.getJobContext();
        if (ctx instanceof SelfRemovalJobContext) {
            ctx = ((SelfRemovalJobContext)ctx).getJobContext();
        }
        Map<Long, TimerJobInstance> instances = null;
        if (this.hasMethod(ctx.getClass(), "getSessionId")) {
            int sessionId = this.getMethodIntValue(ctx, "sessionId");
            instances = this.timerInstances.get(sessionId);
            if (instances == null) {
                instances = new ConcurrentHashMap<Long, TimerJobInstance>();
                this.timerInstances.put(sessionId, instances);
            }
        } else {
            instances = this.singleTimerInstances;
        }
        instances.put(instance.getJobHandle().getId(), instance);
    }

    public void removeTimerJobInstance(TimerJobInstance instance) {
        JobContext ctx = instance.getJobContext();
        if (ctx instanceof SelfRemovalJobContext) {
            ctx = ((SelfRemovalJobContext)ctx).getJobContext();
        }
        Map<Long, TimerJobInstance> instances = null;
        if (this.hasMethod(ctx.getClass(), "getSessionId")) {
            int sessionId = this.getMethodIntValue(ctx, "getSessionId");
            instances = this.timerInstances.get(sessionId);
            if (instances == null) {
                instances = new ConcurrentHashMap<Long, TimerJobInstance>();
                this.timerInstances.put(sessionId, instances);
            }
        } else {
            instances = this.singleTimerInstances;
        }
        instances.remove(instance.getJobHandle().getId());
    }

    public Collection<TimerJobInstance> getTimerJobInstances() {
        return this.singleTimerInstances.values();
    }

    public Collection<TimerJobInstance> getTimerJobInstances(Integer sessionId) {
        Map<Long, TimerJobInstance> sessionTimerJobs = this.timerInstances.get(sessionId);
        if (sessionTimerJobs == null) {
            return Collections.emptyList();
        }
        return sessionTimerJobs.values();
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    private boolean hasMethod(Class<?> clazz, String methodName) {
        try {
            clazz.getDeclaredMethod(methodName, new Class[0]);
            return true;
        }
        catch (Exception e) {
            try {
                clazz.getMethod(methodName, new Class[0]);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private int getMethodIntValue(Object obj, String methodName) {
        Method m = null;
        Class<?> clazz = obj.getClass();
        try {
            m = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            try {
                m = clazz.getMethod(methodName, new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return (Integer)m.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

