/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.infinispan.marshaller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.Id;
import org.drools.core.common.DroolsObjectInputStream;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanPlaceholderResolverStrategy
implements ObjectMarshallingStrategy {
    private static Logger log = LoggerFactory.getLogger(InfinispanPlaceholderResolverStrategy.class);
    private Environment env;

    public InfinispanPlaceholderResolverStrategy(Environment env) {
        this.env = env;
    }

    public boolean accept(Object object) {
        return InfinispanPlaceholderResolverStrategy.isEntity(object) && InfinispanPlaceholderResolverStrategy.isIndexed(object);
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        os.writeObject(InfinispanPlaceholderResolverStrategy.getTypeString(object) + InfinispanPlaceholderResolverStrategy.getClassIdValue(object));
    }

    public Object read(ObjectInputStream is) throws IOException, ClassNotFoundException {
        Object id = is.readObject();
        DefaultCacheManager cm = (DefaultCacheManager)this.env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        Cache cache = cm.getCache("jbpm-configured-cache");
        return cache.get(id);
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buff);
        oos.writeObject(InfinispanPlaceholderResolverStrategy.getTypeString(object) + InfinispanPlaceholderResolverStrategy.getClassIdValue(object));
        oos.close();
        return buff.toByteArray();
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream ois, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream is = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(object), classloader);
        Object id = is.readObject();
        DefaultCacheManager cm = (DefaultCacheManager)this.env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        Cache cache = cm.getCache("jbpm-configured-cache");
        return cache.get(id);
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }

    public static String getTypeString(Object o) {
        String typeValue = null;
        try {
            Field[] fields = o.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length && typeValue == null; ++i) {
                Field field = fields[i];
                if (!field.getName().equals("type")) continue;
                try {
                    String methodName = "get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1);
                    typeValue = (String)o.getClass().getMethod(methodName, null).invoke(o, new Object[0]);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    typeValue = (String)field.get(o);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (typeValue == null) {
            typeValue = "";
        }
        return typeValue;
    }

    public static Serializable getClassIdValue(Object o) {
        Class<?> varClass = o.getClass();
        Serializable idValue = null;
        try {
            Id id;
            int i;
            do {
                Field[] fields = varClass.getDeclaredFields();
                for (i = 0; i < fields.length && idValue == null; ++i) {
                    Field field = fields[i];
                    id = field.getAnnotation(Id.class);
                    if (id == null) continue;
                    try {
                        idValue = InfinispanPlaceholderResolverStrategy.callIdMethod(o, "get" + Character.toUpperCase(field.getName().charAt(0)) + field.getName().substring(1));
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        idValue = (Serializable)field.get(o);
                    }
                }
            } while ((varClass = varClass.getSuperclass()) != null && idValue == null);
            if (idValue == null) {
                varClass = o.getClass();
                do {
                    Method[] methods = varClass.getMethods();
                    for (i = 0; i < methods.length && idValue == null; ++i) {
                        Method method = methods[i];
                        id = method.getAnnotation(Id.class);
                        if (id == null) continue;
                        idValue = (Serializable)method.invoke(o, new Object[0]);
                    }
                } while ((varClass = varClass.getSuperclass()) != null && idValue == null);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
        return idValue;
    }

    private static Serializable callIdMethod(Object target, String methodName) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (Serializable)target.getClass().getMethod(methodName, null).invoke(target, new Object[0]);
    }

    private static boolean isIndexed(Object o) {
        Class<?> varClass = o.getClass();
        do {
            Indexed idx;
            if ((idx = varClass.getAnnotation(Indexed.class)) == null) continue;
            return true;
        } while ((varClass = varClass.getSuperclass()) != null);
        return false;
    }

    private static boolean isEntity(Object o) {
        Id id;
        int i;
        Class<?> varClass = o.getClass();
        do {
            Field[] fields = varClass.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                id = field.getAnnotation(Id.class);
                if (id == null) continue;
                return true;
            }
        } while ((varClass = varClass.getSuperclass()) != null);
        varClass = o.getClass();
        do {
            Method[] methods = varClass.getMethods();
            for (i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                id = method.getAnnotation(Id.class);
                if (id == null) continue;
                return true;
            }
        } while ((varClass = varClass.getSuperclass()) != null);
        return false;
    }
}

