/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import org.junit.Assert;
import org.junit.Test;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.PollUnit;

public class EnvConfigTest {
    @Test
    public void defaultConfigEnvTest() {
        EnvConfig config = EnvConfig.getDefaultEnvConfig();
        Assert.assertEquals((Object)"default", (Object)config.getNamespace());
        Assert.assertEquals((Object)"control", (Object)config.getControlTopicName());
        Assert.assertEquals((Object)"events", (Object)config.getEventsTopicName());
        Assert.assertEquals((Object)"kiesessioninfos", (Object)config.getKieSessionInfosTopicName());
        Assert.assertEquals((Object)"snapshot", (Object)config.getSnapshotTopicName());
        Assert.assertEquals((Object)PollUnit.MILLISECOND, (Object)config.getPollUnit());
        Assert.assertEquals((Object)PollUnit.SECOND, (Object)config.getPollSnapshotUnit());
        Assert.assertTrue((1 == config.getPollSnapshotTimeout() ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void pollTimeUnitExceptionTest() {
        EnvConfig.anEnvConfig().withPollTimeUnit(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void pollSnapshotTimeUnitExceptionTest() {
        EnvConfig.anEnvConfig().withPollSnapshotTimeUnit(null);
    }

    @Test
    public void pollSnapshotTimeUnitMillisTest() {
        EnvConfig config = EnvConfig.anEnvConfig().withPollSnapshotTimeUnit("millisec");
        Assert.assertEquals((Object)PollUnit.MILLISECOND, (Object)config.getPollSnapshotUnit());
    }
}

