/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.consumer;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.CommandHandler;
import org.kie.hacep.consumer.FactHandlesManager;
import org.kie.hacep.core.KieSessionContext;
import org.kie.hacep.core.infra.SessionSnapshooter;
import org.kie.hacep.util.ConsumerUtilsCore;
import org.kie.remote.DroolsExecutor;
import org.kie.remote.RemoteFactHandle;
import org.kie.remote.command.DeleteCommand;
import org.kie.remote.command.EventInsertCommand;
import org.kie.remote.command.FactCountCommand;
import org.kie.remote.command.FireAllRulesCommand;
import org.kie.remote.command.FireUntilHaltCommand;
import org.kie.remote.command.GetKJarGAVCommand;
import org.kie.remote.command.GetObjectCommand;
import org.kie.remote.command.HaltCommand;
import org.kie.remote.command.InsertCommand;
import org.kie.remote.command.ListObjectsCommand;
import org.kie.remote.command.ListObjectsCommandClassType;
import org.kie.remote.command.ListObjectsCommandNamedQuery;
import org.kie.remote.command.RemoteCommand;
import org.kie.remote.command.SnapshotOnDemandCommand;
import org.kie.remote.command.UpdateCommand;
import org.kie.remote.command.UpdateKJarCommand;
import org.kie.remote.impl.RemoteFactHandleImpl;
import org.kie.remote.impl.producer.Producer;
import org.kie.remote.message.ControlMessage;
import org.kie.remote.message.FactCountMessage;
import org.kie.remote.message.FireAllRuleMessage;
import org.kie.remote.message.GetKJarGAVMessage;
import org.kie.remote.message.GetObjectMessage;
import org.kie.remote.message.ListKieSessionObjectMessage;
import org.kie.remote.message.ResultMessage;
import org.kie.remote.message.UpdateKJarMessage;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class CommandHandlerTest {
    protected static final EnvConfig envConfig = EnvConfig.getDefaultEnvConfig();
    protected static final int fireAllRule = 4;
    protected static final long factCount = 4L;
    protected static final String myObject = "myObject";
    protected static final String myEntryPoint = "myEntryPoint";
    protected static final String namedQuery = "namedQuery";
    protected static final String objectName = "objectName";
    protected static final String kJarGAV = "org.kie:fake-jar:0.1-SNAPSHOT";
    protected static final RemoteFactHandle remoteFactHandle = new RemoteFactHandleImpl((Object)"myObject");
    private static final Logger logger = LoggerFactory.getLogger(CommandHandlerTest.class);
    @Mock
    protected KieSessionContext kieSessionContextMock;
    @Mock
    protected Producer producerMock;
    @Mock
    protected SessionSnapshooter sessionSnapshooterMock;
    @Mock
    protected KieSession kieSessionMock;
    @Mock
    protected EntryPoint entryPointMock;
    @Mock
    protected FactHandlesManager factHandlesManagerMock;
    @Mock
    protected FactHandle factHandleMock;
    @Mock
    protected QueryResults queryResultsMock;
    @Mock
    protected ReleaseId releaseIdMock;
    @Mock
    protected KieServices kieServicesMock;
    @Mock
    protected KieContainer kieContainerMock;
    @Captor
    protected ArgumentCaptor<ResultMessage<Object>> messageArgumentCaptor;
    protected CommandHandler commandHandler;

    @Before
    public void initTest() {
        Mockito.when((Object)this.kieSessionContextMock.getKieSession()).thenReturn((Object)this.kieSessionMock);
        Mockito.when((Object)this.kieSessionContextMock.getFhManager()).thenReturn((Object)this.factHandlesManagerMock);
        Mockito.when((Object)this.kieSessionMock.fireAllRules()).thenReturn((Object)4);
        Mockito.when((Object)this.kieSessionMock.getFactCount()).thenReturn((Object)4L);
        Mockito.when((Object)this.kieSessionMock.getEntryPoint(Matchers.anyString())).thenReturn((Object)this.entryPointMock);
        Mockito.when((Object)this.kieSessionMock.getQueryResults(Matchers.anyString(), new Object[0])).thenReturn((Object)this.queryResultsMock);
        Mockito.when((Object)this.kieSessionContextMock.getKjarGAVUsed()).thenReturn(Optional.of(kJarGAV));
        Mockito.when((Object)this.queryResultsMock.iterator()).thenReturn(Collections.emptyIterator());
        ((EntryPoint)Mockito.doReturn(Collections.singletonList(myObject)).when((Object)this.entryPointMock)).getObjects();
        ((KieSession)Mockito.doReturn(Collections.singletonList(myObject)).when((Object)this.kieSessionMock)).getObjects((ObjectFilter)Matchers.any());
        Mockito.when((Object)this.kieSessionMock.getObject((FactHandle)Matchers.any())).thenReturn((Object)myObject);
        Mockito.when((Object)this.factHandlesManagerMock.mapRemoteFactHandle((RemoteFactHandle)Matchers.any(RemoteFactHandle.class))).thenReturn((Object)this.factHandleMock);
        this.commandHandler = new CommandHandler(this.kieSessionContextMock, envConfig, this.producerMock, this.sessionSnapshooterMock, new ConsumerUtilsCore(){

            public ControlMessage getLastEvent(String topic, Integer pollTimeout) {
                return new ControlMessage();
            }

            public ControlMessage getLastEvent(String topic, Properties properties, Integer pollTimeout) {
                return new ControlMessage();
            }
        });
        DroolsExecutor.setAsLeader();
    }

    @After
    public void endTest() {
        DroolsExecutor.setAsLeader();
    }

    @Test
    public void visitFireAllRulesCommand() {
        FireAllRulesCommand command = new FireAllRulesCommand();
        this.executeAndVerifyResponseMessage(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), FireAllRuleMessage.class, result -> result.equals(new Long(4L)));
        Mockito.reset((Object[])new Producer[]{this.producerMock});
        Mockito.reset((Object[])new KieSession[]{this.kieSessionMock});
        DroolsExecutor.setAsReplica();
        this.executeAndVerify(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), () -> ((KieSession)Mockito.verify((Object)this.kieSessionMock, (VerificationMode)Mockito.times((int)1))).fireAllRules());
        logger.info("FireAllRulesCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitFireUntilHaltCommand() {
        FireUntilHaltCommand command = new FireUntilHaltCommand();
        this.executeAndVerify(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), () -> Assert.assertTrue((boolean)this.commandHandler.isFiringUntilHalt()));
        logger.info("FireUntilHaltCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitHaltCommand() {
        HaltCommand command = new HaltCommand();
        this.executeAndVerify(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), () -> Assert.assertFalse((boolean)this.commandHandler.isFiringUntilHalt()));
        logger.info("HaltCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitInsertCommand() {
        InsertCommand command = new InsertCommand(remoteFactHandle, myEntryPoint);
        this.executeAndVerify(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), () -> {
            ((FactHandlesManager)Mockito.verify((Object)this.factHandlesManagerMock, (VerificationMode)Mockito.times((int)1))).registerHandle((RemoteFactHandle)Matchers.eq((Object)remoteFactHandle), (FactHandle)Matchers.any(FactHandle.class));
            ((EntryPoint)Mockito.verify((Object)this.entryPointMock, (VerificationMode)Mockito.times((int)1))).insert(Matchers.eq((Object)myObject));
        });
        logger.info("InsertCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitEventInsertCommand() {
        EventInsertCommand command = new EventInsertCommand((Serializable)((Object)myObject), myEntryPoint);
        this.executeAndVerify(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), () -> ((EntryPoint)Mockito.verify((Object)this.entryPointMock, (VerificationMode)Mockito.times((int)1))).insert(Matchers.eq((Object)myObject)));
        logger.info("EventInsertCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitDeleteCommand() {
        DeleteCommand command = new DeleteCommand(remoteFactHandle, myEntryPoint);
        this.executeAndVerify(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), () -> {
            ((KieSession)Mockito.verify((Object)this.kieSessionMock, (VerificationMode)Mockito.times((int)1))).getEntryPoint((String)Matchers.eq((Object)myEntryPoint));
            ((EntryPoint)Mockito.verify((Object)this.entryPointMock, (VerificationMode)Mockito.times((int)1))).delete((FactHandle)Matchers.eq((Object)this.factHandleMock));
        });
        logger.info("DeleteCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitUpdateCommand() {
        UpdateCommand command = new UpdateCommand(remoteFactHandle, (Object)myObject, myEntryPoint);
        this.executeAndVerify(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), () -> {
            ((KieSession)Mockito.verify((Object)this.kieSessionMock, (VerificationMode)Mockito.times((int)1))).getEntryPoint((String)Matchers.eq((Object)myEntryPoint));
            ((EntryPoint)Mockito.verify((Object)this.entryPointMock, (VerificationMode)Mockito.times((int)1))).update((FactHandle)Matchers.eq((Object)this.factHandleMock), Matchers.eq((Object)myObject));
        });
        logger.info("UpdateCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitListObjectsCommand() {
        ListObjectsCommand command = new ListObjectsCommand(myEntryPoint);
        this.executeAndVerifyResponseMessage(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), ListKieSessionObjectMessage.class, result -> myObject.equals(((List)result).get(0)));
        logger.info("ListObjectsCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitListObjectsCommandClassType() {
        ListObjectsCommandClassType command = new ListObjectsCommandClassType(myEntryPoint, String.class);
        this.executeAndVerifyResponseMessage(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), ListKieSessionObjectMessage.class, result -> myObject.equals(((List)result).get(0)));
        logger.info("ListObjectsCommandClassType:{} ListKieSessionObjectMessage:{}", (Object)command.toString());
    }

    @Test
    public void visitGetObjectCommand() {
        GetObjectCommand command = new GetObjectCommand(remoteFactHandle);
        this.executeAndVerifyResponseMessage(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), GetObjectMessage.class, myObject::equals);
        logger.info("GetObjectCommand:{} GetObjectMessage:{}", (Object)command.toString(), (Object)GetObjectMessage.class.toString());
    }

    @Test
    public void visitListObjectsCommandNamedQuery() {
        ListObjectsCommandNamedQuery command = new ListObjectsCommandNamedQuery(myEntryPoint, namedQuery, objectName, new Object[0]);
        this.executeAndVerifyResponseMessage(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), ListKieSessionObjectMessage.class, result -> ((List)result).size() == 0);
        logger.info("ListObjectsCommandNamedQuery:{}", (Object)command.toString());
    }

    @Test
    public void visitFactCountCommand() {
        FactCountCommand command = new FactCountCommand(myEntryPoint);
        this.executeAndVerifyResponseMessage(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), FactCountMessage.class, result -> new Long(4L).equals(result));
        logger.info("FactCountCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitSnapshotOnDemandCommand() {
        SnapshotOnDemandCommand command = new SnapshotOnDemandCommand();
        this.executeAndVerify(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), () -> ((SessionSnapshooter)Mockito.verify((Object)this.sessionSnapshooterMock, (VerificationMode)Mockito.times((int)1))).serialize((KieSessionContext)Matchers.eq((Object)this.kieSessionContextMock), Matchers.anyString(), Matchers.anyLong()));
        logger.info("SnapshotOnDemandCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitGetKJarGAVCommand() {
        GetKJarGAVCommand command = new GetKJarGAVCommand(myEntryPoint);
        this.executeAndVerifyResponseMessage(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), GetKJarGAVMessage.class, result -> kJarGAV.equals(result));
        logger.info("GetKJarGAVCommand:{}", (Object)command.toString());
    }

    @Test
    public void visitUpdateKJarCommand() {
        envConfig.withUpdatableKJar("true");
        Mockito.when((Object)this.kieSessionContextMock.getKjarGAVUsed()).thenReturn(Optional.of(kJarGAV));
        Mockito.when((Object)this.kieSessionContextMock.getKieContainer()).thenReturn((Object)this.kieContainerMock);
        Mockito.when((Object)this.kieServicesMock.newReleaseId("org.kie", "fake-jar", "0.1-SNAPSHOT")).thenReturn((Object)this.releaseIdMock);
        UpdateKJarCommand command = new UpdateKJarCommand(kJarGAV);
        this.executeAndVerifyResponseMessage(command, arg_0 -> ((CommandHandler)this.commandHandler).visit(arg_0), UpdateKJarMessage.class, result -> Boolean.TRUE);
        logger.info("UpdateKJarCommand:{}", (Object)command.toString());
    }

    private <T extends RemoteCommand> void executeAndVerify(T command, Consumer<T> consumer, Runnable assertions) {
        this.internalExecuteAndVerify(false, command, consumer, null, result -> {
            assertions.run();
            return true;
        });
    }

    private <T extends RemoteCommand> void executeAndVerifyResponseMessage(T command, Consumer<T> consumer, Class<? extends ResultMessage<?>> expectedMessageClass, Function<Object, Boolean> checkOnMessage) {
        this.internalExecuteAndVerify(true, command, consumer, expectedMessageClass, checkOnMessage);
    }

    private <T extends RemoteCommand> void internalExecuteAndVerify(boolean hasReturnMessage, T command, Consumer<T> consumer, Class<? extends ResultMessage<?>> expectedMessageClass, Function<Object, Boolean> predicate) {
        consumer.accept(command);
        if (hasReturnMessage) {
            ((Producer)Mockito.verify((Object)this.producerMock, (VerificationMode)Mockito.times((int)1))).produceSync((String)Matchers.eq((Object)"kiesessioninfos"), (String)Matchers.eq((Object)command.getId()), (ResultMessage)this.messageArgumentCaptor.capture());
            ResultMessage value = (ResultMessage)this.messageArgumentCaptor.getValue();
            Assert.assertFalse((command.isPermittedForReplicas() && !(command instanceof FireAllRulesCommand) && !(command instanceof UpdateKJarCommand) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)expectedMessageClass.isAssignableFrom(value.getClass()));
            Assert.assertEquals((Object)command.getId(), (Object)value.getId());
            Assert.assertTrue((boolean)predicate.apply(value.getResult()));
        } else {
            ((Producer)Mockito.verify((Object)this.producerMock, (VerificationMode)Mockito.never())).produceSync((String)Matchers.eq((Object)"kiesessioninfos"), (String)Matchers.eq((Object)command.getId()), (ResultMessage)this.messageArgumentCaptor.capture());
            Assert.assertTrue((command.isPermittedForReplicas() || command instanceof SnapshotOnDemandCommand ? 1 : 0) != 0);
            Assert.assertTrue((boolean)predicate.apply(null));
        }
    }
}

