/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core.infra;

import java.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.consumer.FactHandlesManager;
import org.kie.hacep.consumer.KieContainerUtils;
import org.kie.hacep.core.infra.SnapshotInfos;

public class SnapshotInfosTest {
    @Test
    public void constructorTest() {
        EnvConfig config = EnvConfig.getDefaultEnvConfig();
        KieServices ks = KieServices.get();
        KieContainer kieContainer = KieContainerUtils.getKieContainer((EnvConfig)config, (KieServices)ks);
        KieSession kieSession = kieContainer.newKieSession();
        FactHandlesManager fhManager = new FactHandlesManager(kieSession);
        String keyDuringSnapshot = "111";
        long offsetDuringSnapshot = 10L;
        LocalDateTime time = LocalDateTime.now();
        String kjarGAV = "org.kie:fake:1.0.0.Snapshot";
        SnapshotInfos infos = new SnapshotInfos(kieSession, kieContainer, fhManager, keyDuringSnapshot, offsetDuringSnapshot, time, kjarGAV);
        Assert.assertNotNull((Object)infos);
        Assert.assertTrue((infos.getFhManager().getFhMapKeys().size() == fhManager.getFhMapKeys().size() ? 1 : 0) != 0);
        Assert.assertEquals((Object)infos.getKeyDuringSnaphot(), (Object)keyDuringSnapshot);
        Assert.assertEquals((Object)infos.getKieContainer(), (Object)kieContainer);
        Assert.assertEquals((Object)infos.getKieSession(), (Object)kieSession);
        Assert.assertEquals((long)infos.getOffsetDuringSnapshot(), (long)offsetDuringSnapshot);
        Assert.assertEquals((Object)infos.getTime(), (Object)time);
        Assert.assertEquals((Object)infos.getkJarGAV(), (Object)kjarGAV);
    }
}

