/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.consumer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.common.InternalFactHandle;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.hacep.consumer.BidirectionalMap;
import org.kie.remote.RemoteFactHandle;

public class FactHandlesManager
implements Serializable {
    private BidirectionalMap<RemoteFactHandle, Long> fhIdMap;
    private transient KieSession kieSession;
    private transient Map<RemoteFactHandle, InternalFactHandle> fhMap;

    public FactHandlesManager() {
        this.fhMap = new HashMap<RemoteFactHandle, InternalFactHandle>();
        this.fhIdMap = new BidirectionalMap();
    }

    public FactHandlesManager(KieSession kieSession) {
        this.kieSession = kieSession;
        this.fhMap = new HashMap<RemoteFactHandle, InternalFactHandle>();
        this.fhIdMap = new BidirectionalMap();
    }

    public Set<RemoteFactHandle> getFhMapKeys() {
        return this.fhIdMap.keySet();
    }

    public void registerHandle(RemoteFactHandle remoteFH, FactHandle fh) {
        InternalFactHandle ifh = (InternalFactHandle)fh;
        this.fhMap.put(remoteFH, ifh);
        this.fhIdMap.put(remoteFH, ifh.getId());
    }

    public FactHandlesManager initFromKieSession(KieSession kieSession) {
        this.kieSession = kieSession;
        kieSession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener(){

            public void objectDeleted(ObjectDeletedEvent objectDeletedEvent) {
                FactHandlesManager.this.fhMap.remove(FactHandlesManager.this.fhIdMap.removeValue(((InternalFactHandle)objectDeletedEvent.getFactHandle()).getId()));
            }
        });
        this.fhMap.clear();
        return this;
    }

    public FactHandle mapRemoteFactHandle(RemoteFactHandle remoteFH) {
        return (FactHandle)this.fhMap.computeIfAbsent(remoteFH, this::getFactHandleById);
    }

    InternalFactHandle getFactHandleById(RemoteFactHandle remoteFH) {
        long id = (Long)this.fhIdMap.get(remoteFH);
        for (FactHandle fh : this.kieSession.getFactHandles((ObjectFilter)new ClassObjectFilter(remoteFH.getObject().getClass()))) {
            InternalFactHandle ifh = (InternalFactHandle)fh;
            if (ifh.getId() != id) continue;
            return ifh;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.fhIdMap.keySet().toString();
    }
}

