/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.kie.integration.eap.maven.EAPBaseMojo;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModulesGraph;
import org.kie.integration.eap.maven.template.EAPTemplateBuilder;
import org.kie.integration.eap.maven.util.EAPFileUtils;

public class EAPStaticModulesBuilderMojo
extends EAPBaseMojo {
    private static final String OUTPUT_STATIC_MODULES = "static-modules";
    private static final String MODULE_DESCRIPTOR_NAME = "module.xml";
    private static final String MODULE_ASSEMBLY_NAME = "component.xml";
    private static final String LAYERS_DESCRIPTOR_NAME = "layers.conf";
    private static final String GLOBAL_ASSEMBLY__DESCRIPTOR_NAME = "-assembly.xml";
    private static final String ASSEMBLY_OUTPUT_PATH = "modules" + File.separator + "system" + File.separator + "layers";
    private EAPTemplateBuilder templateBuilder;
    protected String outputPath;
    protected String assemblyFormats;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        String distroString = this.distribution.print();
        this.getLog().info((CharSequence)distroString);
        if (this.outputPath == null || this.outputPath.trim().length() == 0) {
            throw new MojoFailureException("Output path value missing.");
        }
        String _outputPath = this.outputPath.replaceAll("/", File.separator);
        String distroOutputPath = _outputPath + File.separator + OUTPUT_STATIC_MODULES + File.separator + this.distributionName;
        File outputPathFile = new File(_outputPath);
        File distroOutputPathFile = new File(distroOutputPath);
        outputPathFile.mkdirs();
        distroOutputPathFile.mkdirs();
        StringBuilder outputAssemblyDistroPath = new StringBuilder(ASSEMBLY_OUTPUT_PATH).append(File.separator).append(this.distributionName);
        String layersDescriptor = this.generateLayersDescriptor(this.distribution.getGraph());
        try {
            EAPFileUtils.writeFile(distroOutputPathFile, LAYERS_DESCRIPTOR_NAME, layersDescriptor);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write layer descriptor file.", (Exception)e);
        }
        String[] componentDescriptors = new String[this.distribution.getGraph().getNodes().size()];
        int index = 0;
        for (EAPModuleGraphNode node : this.distribution.getGraph().getNodes()) {
            String _outputModulePath = distroOutputPath + File.separator + node.getName();
            File outputModulePath = new File(_outputModulePath);
            String moduleDescriptor = this.generateModuleDescriptor(node);
            String moduleLocation = node.getLocation().replaceAll("/", File.separator);
            String moduleAssemblyOutputPath = new StringBuilder(outputAssemblyDistroPath).append(File.separator).append(moduleLocation).append(File.separator).append(node.getSlot()).toString();
            String moduleAssembly = this.generateModuleAssemblyComponent(node, _outputModulePath + File.separator + MODULE_DESCRIPTOR_NAME, moduleAssemblyOutputPath);
            componentDescriptors[index] = _outputModulePath + File.separator + MODULE_ASSEMBLY_NAME;
            try {
                EAPFileUtils.writeFile(outputModulePath, MODULE_DESCRIPTOR_NAME, moduleDescriptor);
                EAPFileUtils.writeFile(outputModulePath, MODULE_ASSEMBLY_NAME, moduleAssembly);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write descriptor files for module " + node.getName(), (Exception)e);
            }
            ++index;
        }
        String layerId = this.distributionName + "-layer";
        String[] formats = this.getAssemblyFormats();
        String layerDescriptorFilePath = distroOutputPath + File.separator + LAYERS_DESCRIPTOR_NAME;
        String globalAssemblyFileName = this.distributionName + GLOBAL_ASSEMBLY__DESCRIPTOR_NAME;
        String globalAssembly = this.generateGlobalAssembly(layerId, formats, layerDescriptorFilePath, componentDescriptors);
        try {
            EAPFileUtils.writeFile(distroOutputPathFile, globalAssemblyFileName, globalAssembly);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write the global assembly descritpro file.", (Exception)e);
        }
        this.writeDistributionProperties();
    }

    protected void writeDistributionProperties() throws MojoExecutionException {
        if (this.distribution.getGraph() != null) {
            String[] _distroPackage = "org.kie.integration.eap.maven.distributions".split("\\.");
            StringBuilder distroPath = new StringBuilder(this.project.getBuild().getOutputDirectory());
            for (String dp : _distroPackage) {
                distroPath.append(File.separator).append(dp);
            }
            try {
                String distroDefinition = (String)this.distributionManager.write(this.distribution);
                File distroPathFile = new File(distroPath.toString());
                distroPathFile.mkdirs();
                File file = new File(distroPathFile, "distribution.xml");
                EAPFileUtils.writeToFile(distroDefinition, file);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot generate the distribution package file.", e);
            }
        }
    }

    private String[] getAssemblyFormats() {
        return this.assemblyFormats.split(",");
    }

    protected String generateGlobalAssembly(String layerId, String[] formats, String layerDescriptorFilePath, String[] componentDescriptorsFilePaths) {
        return this.templateBuilder.buildGlobalAssembly(layerId, formats, layerDescriptorFilePath, componentDescriptorsFilePaths);
    }

    protected String generateModuleDescriptor(EAPModuleGraphNode node) {
        return this.templateBuilder.buildModuleDescriptor(node);
    }

    protected String generateModuleAssemblyComponent(EAPModuleGraphNode node, String moduleDescriptorPath, String outputPath) {
        return this.templateBuilder.buildModuleAssemblyComponent(node, moduleDescriptorPath, outputPath);
    }

    protected String generateLayersDescriptor(EAPModulesGraph graph) {
        return this.templateBuilder.buildLayersConfiguration(graph);
    }
}

