/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.patch;

import java.util.Collection;
import java.util.Properties;
import org.kie.integration.eap.maven.model.layer.EAPLayer;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.kie.integration.eap.maven.patch.EAPAbstractPatch;
import org.kie.integration.eap.maven.patch.EAPPatchException;
import org.kie.integration.eap.maven.util.EAPArtifactUtils;
import org.sonatype.aether.artifact.Artifact;

public abstract class EAPStaticModulesPatch
extends EAPAbstractPatch {
    protected EAPLayer staticLayer;

    public void setStaticLayer(EAPLayer staticLayer) {
        this.staticLayer = staticLayer;
    }

    public EAPLayer getStaticLayer() {
        return this.staticLayer;
    }

    public abstract void execute(EAPModule var1, Properties var2) throws EAPPatchException;

    @Override
    public void execute() throws EAPPatchException {
        if (this.staticLayer == null) {
            throw new EAPPatchException("The static layer is not set.", this.getId());
        }
        Collection<EAPModule> nodes = this.staticLayer.getModules();
        if (nodes != null && !nodes.isEmpty()) {
            for (EAPModule node : nodes) {
                Properties nodePatchProperties = this.getModulePatchProperties(node);
                if (nodePatchProperties == null || nodePatchProperties.isEmpty()) continue;
                this.execute(node, nodePatchProperties);
            }
        }
    }

    public Properties getModulePatchProperties(EAPModule module) {
        Properties p = module.getProperties();
        return this.getPatchProperties(p);
    }

    protected Artifact getArtifact(EAPModule module, String coordinates) {
        if (coordinates == null || coordinates.trim().length() == 0) {
            return null;
        }
        Artifact source = EAPArtifactUtils.createArtifact(coordinates);
        Collection<EAPModuleResource> resources = module.getResources();
        if (resources != null && !resources.isEmpty()) {
            for (EAPModuleResource resource : resources) {
                try {
                    Artifact resourceArtifact = (Artifact)resource.getResource();
                    if (EAPArtifactUtils.equals(source, resourceArtifact)) {
                        return resourceArtifact;
                    }
                    if (!EAPArtifactUtils.equalsNoVersion(source, resourceArtifact)) continue;
                    return resourceArtifact;
                }
                catch (ClassCastException e) {
                }
            }
        }
        return null;
    }
}

