/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.kie.integration.eap.maven.exception.EAPModuleDefinitionException;
import org.kie.integration.eap.maven.model.dependency.EAPStaticModuleDependency;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNode;
import org.kie.integration.eap.maven.model.graph.EAPModuleGraphNodeResource;
import org.kie.integration.eap.maven.model.graph.EAPModulesGraph;
import org.kie.integration.eap.maven.model.module.EAPModule;
import org.kie.integration.eap.maven.model.resource.EAPModuleResource;
import org.kie.integration.eap.maven.util.EAPArtifactsHolder;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.graph.selector.AndDependencySelector;
import org.sonatype.aether.util.graph.selector.ExclusionDependencySelector;
import org.sonatype.aether.util.graph.selector.OptionalDependencySelector;
import org.sonatype.aether.util.graph.selector.ScopeDependencySelector;
import org.sonatype.aether.util.graph.transformer.NoopDependencyGraphTransformer;

public class EAPArtifactUtils {
    protected static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");
    protected static final Pattern JAR_NAME_PARSER_PATTERN = Pattern.compile("(.*)-(\\d+[\\.-].*).jar");

    public static Artifact createArtifact(String groupId, String artifactId, String version, String packaging) {
        return new DefaultArtifact(groupId, artifactId, packaging, version);
    }

    public static Artifact createArtifact(String artifactCoordinates) {
        String[] coords = EAPArtifactUtils.extractArtifactCorrdinates(artifactCoordinates);
        String groupId = coords[0];
        String artifactId = coords[1];
        String type = coords.length > 2 ? coords[2] : "";
        String version = coords.length > 3 ? coords[3] : "";
        return new DefaultArtifact(groupId, artifactId, type, version);
    }

    public static Artifact createArtifact(String groupId, String artifactId, String version, String packaging, String classifier) {
        return new DefaultArtifact(groupId, artifactId, classifier, packaging, version);
    }

    public static Artifact resolveArtifact(String groupId, String artifactId, String version, String packaging, String classifier, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) throws ArtifactResolutionException {
        Artifact art = EAPArtifactUtils.createArtifact(groupId, artifactId, version, packaging, classifier);
        return EAPArtifactUtils.resolveArtifact(art, repoSystem, repoSession, remoteRepos);
    }

    public static Artifact resolveArtifact(String groupId, String artifactId, String version, String packaging, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) throws ArtifactResolutionException {
        Artifact art = EAPArtifactUtils.createArtifact(groupId, artifactId, version, packaging);
        return EAPArtifactUtils.resolveArtifact(art, repoSystem, repoSession, remoteRepos);
    }

    public static Artifact resolveArtifact(Artifact art, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) throws ArtifactResolutionException {
        ArtifactRequest request = new ArtifactRequest(art, remoteRepos, "");
        return repoSystem.resolveArtifact(repoSession, request).getArtifact();
    }

    public static boolean equals(Artifact a1, Artifact a2) {
        String a1Coords = EAPArtifactUtils.getArtifactCoordinates(a1);
        String a2Coords = EAPArtifactUtils.getArtifactCoordinates(a2);
        return a1Coords.equalsIgnoreCase(a2Coords);
    }

    public static boolean equalsNoVersion(Artifact a1, Artifact a2) {
        DefaultArtifact a1Copy = new DefaultArtifact(a1.getGroupId(), a1.getArtifactId(), a1.getExtension(), null);
        DefaultArtifact a2Copy = new DefaultArtifact(a2.getGroupId(), a2.getArtifactId(), a2.getExtension(), null);
        String a1Coords = EAPArtifactUtils.getArtifactCoordinates((Artifact)a1Copy);
        String a2Coords = EAPArtifactUtils.getArtifactCoordinates((Artifact)a2Copy);
        return a1Coords.equalsIgnoreCase(a2Coords);
    }

    public static Artifact cloneArtifact(Artifact a) {
        String groupId = a.getGroupId();
        String artifactId = a.getArtifactId();
        String type = a.getExtension();
        String version = a.getVersion();
        return new DefaultArtifact(groupId, artifactId, type, version);
    }

    public static String[] extractArtifactCorrdinates(String artifactCoordinates) {
        if (artifactCoordinates == null || artifactCoordinates.trim().length() == 0) {
            throw new IllegalArgumentException("Artifact string cannot be null or empty.");
        }
        return artifactCoordinates.split(":");
    }

    public static String getArtifactCoordinates(org.apache.maven.artifact.Artifact artifact) {
        String version;
        if (artifact == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (artifact.getGroupId() != null && artifact.getGroupId().trim().length() > 0) {
            result.append(artifact.getGroupId());
        }
        if (artifact.getArtifactId() != null && artifact.getArtifactId().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getArtifactId());
        }
        if (artifact.getType() != null && artifact.getType().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getType());
        }
        if (artifact.getClassifier() != null && artifact.getClassifier().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getClassifier());
        }
        if ((version = EAPArtifactUtils.toSnaphostVersion(artifact)) != null) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(version);
        }
        return result.toString();
    }

    public static String getArtifactCoordinates(Artifact artifact) {
        String version;
        if (artifact == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (artifact.getGroupId() != null && artifact.getGroupId().trim().length() > 0) {
            result.append(artifact.getGroupId());
        }
        if (artifact.getArtifactId() != null && artifact.getArtifactId().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getArtifactId());
        }
        if (artifact.getExtension() != null && artifact.getExtension().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getExtension());
        }
        if (artifact.getClassifier() != null && artifact.getClassifier().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getClassifier());
        }
        if ((version = EAPArtifactUtils.toSnaphostVersion(artifact)) != null) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(version);
        }
        return result.toString();
    }

    public static String getArtifactCoordinatesWithoutVersion(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (artifact.getGroupId() != null && artifact.getGroupId().trim().length() > 0) {
            result.append(artifact.getGroupId());
        }
        if (artifact.getArtifactId() != null && artifact.getArtifactId().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getArtifactId());
        }
        if (artifact.getExtension() != null && artifact.getExtension().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getExtension());
        }
        if (artifact.getClassifier() != null && artifact.getClassifier().trim().length() > 0) {
            if (result.length() > 0) {
                result.append(":");
            }
            result.append(artifact.getClassifier());
        }
        return result.toString();
    }

    public static String toSnaphostVersion(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact.getBaseVersion() != null && artifact.getBaseVersion().trim().length() > 0) {
            return artifact.getBaseVersion();
        }
        if (artifact.getVersion() != null && artifact.getVersion().trim().length() > 0) {
            return artifact.getVersion();
        }
        return null;
    }

    public static String toSnaphostVersion(org.apache.maven.artifact.Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact.getBaseVersion() != null && artifact.getBaseVersion().trim().length() > 0) {
            return artifact.getBaseVersion();
        }
        if (artifact.getVersion() != null && artifact.getVersion().trim().length() > 0) {
            return artifact.getVersion();
        }
        return null;
    }

    public static String getArtifactShortCoordinates(String artifactCoords) {
        if (artifactCoords == null) {
            return null;
        }
        String[] coords = EAPArtifactUtils.extractArtifactCorrdinates(artifactCoords);
        return coords[0] + ":" + coords[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model generateModel(Artifact artifact) throws IOException, XmlPullParserException {
        File pomFile = artifact.getFile();
        FileReader reader = new FileReader(pomFile);
        try {
            Model model;
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            Model model2 = model = xpp3Reader.read((Reader)reader);
            return model2;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public static String getPropertyValue(Model model, String propertyValue) {
        if (model == null && propertyValue != null) {
            return propertyValue;
        }
        if (model == null || propertyValue == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(propertyValue.length());
        Matcher m = PROPERTY_PATTERN.matcher(propertyValue);
        while (m.find()) {
            String pName = m.group(1);
            String pValue = null;
            pValue = "project.version".equalsIgnoreCase(pName) ? model.getParent().getVersion() : (String)model.getProperties().get(pName);
            if (pValue == null) {
                throw new IllegalArgumentException("Cannot resolve the property " + pName + " in project properties.");
            }
            if (PROPERTY_PATTERN.matcher(pValue).matches()) {
                pValue = EAPArtifactUtils.getPropertyValue(model, pValue);
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(pValue));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static void toArtifacts(EAPArtifactsHolder holder, Collection<? extends DependencyNode> nodes, DependencyFilter filter) {
        EAPArtifactUtils.toArtifacts(holder, nodes, filter, 0);
    }

    public static void toArtifacts(EAPArtifactsHolder holder, Collection<? extends DependencyNode> nodes, DependencyFilter filter, int depth) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        int currentDepth = 0;
        EAPArtifactUtils.toArtifacts(holder, nodes, filter, depth, currentDepth);
    }

    public static void toArtifacts(EAPArtifactsHolder holder, Collection<? extends DependencyNode> nodes, DependencyFilter filter, int depth, int currentDepth) {
        if (depth > 0 && depth >= currentDepth) {
            return;
        }
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (DependencyNode dependencyNode : nodes) {
            Artifact artifact = dependencyNode.getDependency().getArtifact();
            if (holder.contains(artifact)) continue;
            if (filter == null || filter.accept(dependencyNode, Collections.emptyList())) {
                holder.add(artifact);
            }
            EAPArtifactUtils.toArtifacts(holder, dependencyNode.getChildren(), filter, depth, ++currentDepth);
        }
    }

    public static Artifact toArtifact(Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        String artifactId = dependency.getArtifact().getArtifactId();
        String groupId = dependency.getArtifact().getGroupId();
        String version = dependency.getArtifact().getVersion();
        String classifier = dependency.getArtifact().getClassifier();
        String packaging = dependency.getArtifact().getExtension();
        if (classifier != null && classifier.trim().length() > 0) {
            return EAPArtifactUtils.createArtifact(groupId, artifactId, version, packaging, classifier);
        }
        return EAPArtifactUtils.createArtifact(groupId, artifactId, version, packaging);
    }

    public static DependencyNode getDependencyGraph(Artifact rootArtifact, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos, boolean includeOptionalDependencies) throws DependencyCollectionException, DependencyResolutionException {
        Dependency rootDependency = new Dependency(rootArtifact, "compile");
        CollectRequest collectRequest = new CollectRequest(rootDependency, remoteRepos);
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(repoSession);
        newSession.setDependencyGraphTransformer(NoopDependencyGraphTransformer.INSTANCE);
        ScopeDependencySelector scopeDependencySelector = new ScopeDependencySelector(new String[]{"test"});
        AndDependencySelector selector = null;
        selector = includeOptionalDependencies ? new AndDependencySelector(new DependencySelector[]{scopeDependencySelector, new ExclusionDependencySelector()}) : new AndDependencySelector(new DependencySelector[]{scopeDependencySelector, new ExclusionDependencySelector(), new OptionalDependencySelector()});
        newSession.setDependencySelector((DependencySelector)selector);
        CollectResult result = repoSystem.collectDependencies((RepositorySystemSession)newSession, collectRequest);
        return result.getRoot();
    }

    public static Artifact createProjectArtifact(MavenProject project) {
        return EAPArtifactUtils.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
    }

    public static String getUID(String name, String slot) {
        if (name == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(name);
        if (slot != null && slot.trim().length() > 0) {
            result.append(":").append(slot);
        }
        return result.toString();
    }

    public static EAPModuleGraphNode getNodeWithResource(Artifact artifact, EAPModulesGraph graph) {
        if (artifact != null && graph != null) {
            String artifactCoordinates = EAPArtifactUtils.getArtifactCoordinates(artifact);
            List<EAPModuleGraphNode> nodes = graph.getNodes();
            if (nodes != null && !nodes.isEmpty()) {
                for (EAPModuleGraphNode node : nodes) {
                    List<EAPModuleGraphNodeResource> resources = node.getResources();
                    if (resources == null || resources.isEmpty()) continue;
                    for (EAPModuleGraphNodeResource resource : resources) {
                        String resourceCoordinates = EAPArtifactUtils.getArtifactCoordinates((Artifact)resource.getResource());
                        if (!artifactCoordinates.equalsIgnoreCase(resourceCoordinates)) continue;
                        return node;
                    }
                }
            }
        }
        return null;
    }

    public static String[] parseFileName(String fileName) {
        String[] result = new String[2];
        Matcher m1 = JAR_NAME_PARSER_PATTERN.matcher(fileName);
        boolean matches = m1.matches();
        if (!matches) {
            result[0] = fileName.substring(0, fileName.length() - 4);
            result[1] = "";
        } else {
            result[0] = m1.group(1);
            result[1] = m1.group(2);
        }
        return result;
    }

    public static boolean isArtifactExcludedInModule(EAPModule module, Artifact artifact) {
        if (module == null || artifact == null) {
            return false;
        }
        Collection<EAPModuleResource> resources = module.getResources();
        if (resources != null && !resources.isEmpty()) {
            for (EAPModuleResource resource : resources) {
                Collection<Exclusion> exclusions = resource.getExclusions();
                if (exclusions == null || exclusions.isEmpty()) continue;
                for (Exclusion exclusion : exclusions) {
                    if (!exclusion.getGroupId().equalsIgnoreCase(artifact.getGroupId()) || !exclusion.getArtifactId().equalsIgnoreCase(artifact.getArtifactId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Collection<EAPStaticModuleDependency> getStaticDependencies(Artifact moduleArtifact, Model moduleModel, String moduleDependenciesRaw) throws EAPModuleDefinitionException {
        LinkedList<EAPStaticModuleDependency> result = null;
        if (moduleDependenciesRaw != null && moduleDependenciesRaw.trim().length() > 0) {
            String[] _moduleDependenciesRaw;
            String moduleArtifactCoordinates = EAPArtifactUtils.getArtifactCoordinates(moduleArtifact);
            result = new LinkedList<EAPStaticModuleDependency>();
            for (String moduleDep : _moduleDependenciesRaw = moduleDependenciesRaw.split(",")) {
                String[] _moduleDep = moduleDep.split(":");
                if (_moduleDep == null || _moduleDep.length < 2) {
                    throw new EAPModuleDefinitionException(moduleArtifactCoordinates, "The static dependency '" + _moduleDep + "' syntax is not correct.");
                }
                String moduleName = EAPArtifactUtils.getPropertyValue(moduleModel, _moduleDep[0]);
                String moduleSlot = EAPArtifactUtils.getPropertyValue(moduleModel, _moduleDep[1]);
                boolean export = false;
                if (_moduleDep.length == 3) {
                    export = Boolean.valueOf(_moduleDep[2]);
                }
                EAPStaticModuleDependency dep = new EAPStaticModuleDependency(moduleName);
                dep.setSlot(moduleSlot);
                dep.setOptional(false);
                dep.setExport(export);
                result.add(dep);
            }
        }
        return result;
    }

    public static boolean isVersionEqualsThan(ComparableVersion version1, ComparableVersion version2) {
        return version1.compareTo(version2) == 0;
    }

    public static boolean isVersionGreaterThan(ComparableVersion version1, ComparableVersion version2) {
        return version1.compareTo(version2) == 1;
    }

    public static boolean isVersionLowerThan(ComparableVersion version1, ComparableVersion version2) {
        return version1.compareTo(version2) == -1;
    }
}

