/*
 * Decompiled with CFR 0.152.
 */
package org.kie.integration.eap.maven.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EAPXMLUtils {
    private InputStream inputFile;
    private Document document;
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public EAPXMLUtils() throws Exception {
    }

    public EAPXMLUtils(InputStream inputFile) throws Exception {
        this.inputFile = inputFile;
        DocumentBuilder builder = this.init();
        if (inputFile != null) {
            this.document = builder.parse(inputFile);
        }
    }

    private DocumentBuilder init() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        return documentBuilderFactory.newDocumentBuilder();
    }

    private void newDocument() throws Exception {
        DocumentBuilder builder = this.init();
        this.document = builder.newDocument();
    }

    public static EAPXMLUtils newInstance() throws Exception {
        EAPXMLUtils result = new EAPXMLUtils();
        result.newDocument();
        return result;
    }

    public Element createElement(String name, Map<String, String> attributes, Element parent) {
        Element element = this.document.createElement(name);
        if (attributes != null) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                String attrName = attribute.getKey();
                String attrValue = attribute.getValue();
                element.setAttribute(attrName, attrValue);
            }
        }
        if (parent != null) {
            parent.appendChild(element);
        }
        return element;
    }

    public static void printInputStreamContent(InputStream is) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((inputLine = in.readLine()) != null) {
            System.out.println(inputLine);
        }
        in.close();
    }

    public static String getAttributeValue(Node node, String attrName) {
        Node attr;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (attr = attrs.getNamedItem(attrName)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public Node getXPathNode(String expr) throws XPathExpressionException {
        return (Node)XPATH.compile(expr).evaluate(this.getDocument(), XPathConstants.NODE);
    }

    public Document getDocument() {
        return this.document;
    }
}

