/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jbpm.process.svg.SVGImageProcessor;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestEvalutionSVG {
    private XPath xpath = XPathFactory.newInstance().newXPath();

    @Test
    public void test() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_343B16DA-961A-49BF-8697-9A86DEAFBAF4");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        String svg = SVGImageProcessor.transform((InputStream)TestEvalutionSVG.class.getResourceAsStream("/evaluation-svg.svg"), completed, active);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active);
        this.validateNodesMarkedAsCompleted(svgDocument, completed);
    }

    @Test
    public void testByName() throws Exception {
        ArrayList<String> completedID = new ArrayList<String>();
        completedID.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        ArrayList<String> activeID = new ArrayList<String>();
        activeID.add("_AE5BF0DC-B720-4FDE-9499-5ED89D41FB1A");
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("Self Evaluation");
        ArrayList<String> active = new ArrayList<String>();
        active.add("PM Evaluation");
        String svg = SVGImageProcessor.transformByName((InputStream)TestEvalutionSVG.class.getResourceAsStream("/evaluation-svg.svg"), completed, active);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, activeID);
        this.validateNodesMarkedAsCompleted(svgDocument, completedID);
    }

    @Test
    public void testCompletedAndActive() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_343B16DA-961A-49BF-8697-9A86DEAFBAF4");
        completed.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_6063D302-9D81-4C86-920B-E808A45377C2");
        String svg = SVGImageProcessor.transform((InputStream)TestEvalutionSVG.class.getResourceAsStream("/evaluation-svg.svg"), completed, active);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active);
        completed.remove("_6063D302-9D81-4C86-920B-E808A45377C2");
        this.validateNodesMarkedAsCompleted(svgDocument, completed);
    }

    private void validateNodesMarkedAsActive(Document svgDocument, List<String> activeNodes) throws XPathExpressionException {
        for (String activeNode : activeNodes) {
            XPathExpression expr = this.xpath.compile("//*[@bpmn2nodeid='" + activeNode + "']");
            Element element = (Element)expr.evaluate(svgDocument, XPathConstants.NODE);
            if (element == null) {
                Assert.fail((String)("Active element " + activeNode + " not found in the document"));
            }
            String svgId = element.getAttribute("id");
            Element border = svgDocument.getElementById(svgId + "bg_frame");
            String marker = border.getAttribute("stroke");
            Assert.assertNotNull((Object)marker);
            Assert.assertEquals((Object)"#FF0000", (Object)marker);
            String markerWidth = border.getAttribute("stroke-width");
            Assert.assertNotNull((Object)markerWidth);
            Assert.assertEquals((Object)"2", (Object)markerWidth);
        }
    }

    private void validateNodesMarkedAsCompleted(Document svgDocument, List<String> completedNodes) throws XPathExpressionException {
        for (String completedNode : completedNodes) {
            XPathExpression expr = this.xpath.compile("//*[@bpmn2nodeid='" + completedNode + "']");
            Element element = (Element)expr.evaluate(svgDocument, XPathConstants.NODE);
            if (element == null) {
                Assert.fail((String)("Completed element " + completedNode + " not found in the document"));
            }
            String svgId = element.getAttribute("id");
            Element background = svgDocument.getElementById(svgId + "fill_el");
            String marker = background.getAttribute("stop-color");
            Assert.assertNotNull((Object)marker);
            Assert.assertEquals((Object)"#C0C0C0", (Object)marker);
        }
    }

    private Document readSVG(String svgContent) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        factory.setValidating(false);
        Document svgDocument = factory.createDocument("http://jbpm.org", (Reader)new StringReader(svgContent));
        return svgDocument;
    }
}

