/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMTSpanElement;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jbpm.process.svg.model.NodeSummary;
import org.jbpm.process.svg.model.SVGSummary;
import org.jbpm.process.svg.model.SetBackgroundColorTransformation;
import org.jbpm.process.svg.model.SetBorderColorTransformation;
import org.jbpm.process.svg.model.SetSubProcessLinkTransformation;
import org.jbpm.process.svg.model.Transformation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGImageProcessor {
    private Document svgDocument;
    private SVGSummary summary = new SVGSummary();
    private boolean mapById = true;

    public SVGImageProcessor(InputStream svg) {
        this(svg, true);
    }

    public SVGImageProcessor(InputStream svg, boolean mapById) {
        this.mapById = mapById;
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            factory.setValidating(false);
            this.svgDocument = factory.createDocument("http://jbpm.org", svg);
            this.processNodes(this.svgDocument.getChildNodes());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse svg", e);
        }
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active) {
        return SVGImageProcessor.transform(svg, completed, active, null);
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active, Map<String, String> subProcessLinks) {
        SVGImageProcessor processor = new SVGImageProcessor(svg);
        for (String string : completed) {
            if (active.contains(string)) continue;
            processor.defaultCompletedTransformation(string);
        }
        for (String string : active) {
            processor.defaultActiveTransformation(string);
        }
        if (subProcessLinks != null) {
            for (Map.Entry entry : subProcessLinks.entrySet()) {
                processor.defaultSubProcessLinkTransformation((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return processor.getSVG();
    }

    public static String transformByName(InputStream svg, List<String> completed, List<String> active) {
        SVGImageProcessor processor = new SVGImageProcessor(svg, false);
        for (String nodeId : completed) {
            if (active.contains(nodeId)) continue;
            processor.defaultCompletedTransformation(nodeId);
        }
        for (String nodeId : active) {
            processor.defaultActiveTransformation(nodeId);
        }
        return processor.getSVG();
    }

    public void transform(Transformation t) {
        t.transform(this.summary);
    }

    public void defaultCompletedTransformation(String nodeId) {
        this.transform(new SetBackgroundColorTransformation(nodeId, "#C0C0C0"));
    }

    public void defaultActiveTransformation(String nodeId) {
        this.transform(new SetBorderColorTransformation(nodeId, "#FF0000"));
    }

    public void defaultSubProcessLinkTransformation(String nodeId, String link) {
        this.transform(new SetSubProcessLinkTransformation(nodeId, link));
    }

    public String getSVG() {
        try {
            DOMSource domSource = new DOMSource(this.svgDocument.getFirstChild());
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException("Could not transform svg", e);
        }
    }

    private void processNodes(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node svgIdNode;
            Node node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null && (svgIdNode = attributes.getNamedItem("id")) != null) {
                String svgId = svgIdNode.getNodeValue();
                if (this.mapById) {
                    Node nodeIdNode = attributes.getNamedItem("bpmn2nodeid");
                    if (nodeIdNode != null) {
                        String nodeId = nodeIdNode.getNodeValue();
                        Element border = null;
                        Element background = null;
                        Element subProcessLink = null;
                        if (nodeId != null) {
                            background = this.svgDocument.getElementById(svgId + "fill_el");
                            border = this.svgDocument.getElementById(svgId + "bg_frame");
                            Element borderSubProcess = this.svgDocument.getElementById(svgId + "frame");
                            subProcessLink = this.svgDocument.getElementById(svgId + "pimg");
                            this.summary.addNode(new NodeSummary(nodeId, border, background, borderSubProcess, subProcessLink));
                        }
                    }
                } else if (svgId.endsWith("text_name")) {
                    svgId = svgId.substring(0, svgId.length() - 9);
                    StringBuilder taskLabel = new StringBuilder();
                    for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                        if (!(node.getChildNodes().item(j) instanceof SVGOMTSpanElement)) continue;
                        SVGOMTSpanElement spanElement = (SVGOMTSpanElement)node.getChildNodes().item(j);
                        taskLabel.append(spanElement.getFirstChild().getNodeValue());
                    }
                    String name = taskLabel.toString();
                    if (!name.trim().isEmpty()) {
                        Element background = this.svgDocument.getElementById(svgId + "fill_el");
                        Element border = this.svgDocument.getElementById(svgId + "bg_frame");
                        Element borderSubProcess = this.svgDocument.getElementById(svgId + "frame");
                        Element subProcessLink = this.svgDocument.getElementById(svgId + "pimg");
                        this.summary.addNode(new NodeSummary(name, border, background, borderSubProcess, subProcessLink));
                    }
                }
            }
            this.processNodes(node.getChildNodes());
        }
    }
}

