/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.prediction.pmml;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.LoadingModelEvaluatorBuilder;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.visitors.DefaultModelEvaluatorBattery;
import org.jpmml.model.visitors.VisitorBattery;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.prediction.PredictionService;
import org.xml.sax.SAXException;

public abstract class AbstractPMMLBackend
implements PredictionService {
    private final Evaluator evaluator;
    private final List<? extends InputField> inputFields;
    private final List<? extends TargetField> targetFields;
    protected final List<? extends OutputField> outputFields;
    protected List<String> inputFeatures;
    protected String outcomeFeatureName;
    protected double confidenceThreshold;

    public AbstractPMMLBackend(List<String> inputFeatures, String outputFeatureName, double confidenceThreshold, File pmmlFile) {
        this.inputFeatures = inputFeatures;
        this.outcomeFeatureName = outputFeatureName;
        this.confidenceThreshold = confidenceThreshold;
        ModelEvaluator _evalutator = null;
        try {
            _evalutator = new LoadingModelEvaluatorBuilder().setLocatable(false).setVisitors((VisitorBattery)new DefaultModelEvaluatorBattery()).load(pmmlFile).build();
            _evalutator.verify();
            this.evaluator = _evalutator;
            this.inputFields = this.evaluator.getInputFields();
            this.targetFields = this.evaluator.getTargetFields();
            this.outputFields = this.evaluator.getOutputFields();
        }
        catch (IOException | JAXBException | SAXException e) {
            throw new RuntimeException("Could not initialise model");
        }
    }

    public void train(Task task, Map<String, Object> inputData, Map<String, Object> outputData) {
    }

    protected abstract Map<String, Object> preProcess(Map<String, Object> var1);

    protected Map<String, ?> evaluate(Map<String, Object> data) {
        Map<String, Object> preProcessed = this.preProcess(data);
        LinkedHashMap<FieldName, FieldValue> arguments = new LinkedHashMap<FieldName, FieldValue>();
        for (InputField inputField : this.inputFields) {
            FieldName inputName = inputField.getName();
            Object rawValue = preProcessed.get(inputName.getValue());
            FieldValue inputValue = inputField.prepare(rawValue);
            arguments.put(inputName, inputValue);
        }
        Map results = this.evaluator.evaluate(arguments);
        return EvaluatorUtil.decodeAll((Map)results);
    }
}

