/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.prediction.pmml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbpm.prediction.pmml.AbstractPMMLBackend;
import org.jbpm.prediction.pmml.PMMLRandomForestConfiguration;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.prediction.PredictionOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLRandomForest
extends AbstractPMMLBackend {
    public static final String IDENTIFIER = "PMMLRandomForest";
    private static final Logger logger = LoggerFactory.getLogger(PMMLRandomForest.class);

    private static Properties readProperties(String propertiesFilename) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = PMMLRandomForest.class.getClassLoader().getResourceAsStream(propertiesFilename);
        if (inputStream == null) {
            throw new FileNotFoundException("Could not find the property file '" + propertiesFilename + "' in the classpath.");
        }
        properties.load(inputStream);
        return properties;
    }

    private static PMMLRandomForestConfiguration readConfigurationFromFile() {
        PMMLRandomForestConfiguration configuration = new PMMLRandomForestConfiguration();
        ArrayList<String> inputFeatures = new ArrayList<String>();
        try {
            Properties inputProperties = PMMLRandomForest.readProperties("inputs.properties");
            for (Object propertyName : inputProperties.keySet()) {
                inputFeatures.add((String)propertyName);
            }
            configuration.setInputFeatures(inputFeatures);
            Properties outputProperties = PMMLRandomForest.readProperties("output.properties");
            configuration.setOutcomeName(outputProperties.getProperty("name"));
            configuration.setConfidenceThreshold(Double.parseDouble(outputProperties.getProperty("confidence_threshold")));
            Properties modelProperties = PMMLRandomForest.readProperties("model.properties");
            String pmmlFilename = modelProperties.getProperty("filename");
            configuration.setModelFile(new File(PMMLRandomForest.class.getClassLoader().getResource(pmmlFilename).getFile()));
            return configuration;
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create service configuration.");
        }
    }

    public PMMLRandomForest() {
        this(PMMLRandomForest.readConfigurationFromFile());
    }

    public PMMLRandomForest(PMMLRandomForestConfiguration configuration) {
        this(configuration.getInputFeatures(), configuration.getOutcomeName(), configuration.getConfidenceThreshold(), configuration.getModelFile());
    }

    public PMMLRandomForest(List<String> inputFeatures, String outputFeatureName, double confidenceThreshold, File pmmlFile) {
        super(inputFeatures, outputFeatureName, confidenceThreshold, pmmlFile);
    }

    @Override
    protected Map<String, Object> preProcess(Map<String, Object> data) {
        HashMap<String, Object> preProcessed = new HashMap<String, Object>();
        for (String input : data.keySet()) {
            if (input.equals("ActorId")) {
                String strValue = (String)data.get(input);
                int rawValue = strValue.equals("john") ? 0 : 1;
                preProcessed.put(input, rawValue);
                continue;
            }
            preProcessed.put(input, data.get(input));
        }
        return preProcessed;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public PredictionOutcome predict(Task task, Map<String, Object> data) {
        Map<String, ?> result = this.evaluate(data);
        HashMap<String, Comparable<Boolean>> outcomes = new HashMap<String, Comparable<Boolean>>();
        Double prediction = (Double)result.get(this.outcomeFeatureName);
        double confidence = Math.max(prediction, Math.abs(1.0 - prediction));
        long predictionInt = Math.round(prediction);
        String predictionStr = predictionInt == 0L ? "false" : "true";
        outcomes.put("approved", Boolean.valueOf(predictionStr));
        outcomes.put("confidence", Double.valueOf(confidence));
        logger.debug(data + ", prediction = " + predictionStr + ", confidence = " + confidence);
        return new PredictionOutcome(confidence, this.confidenceThreshold, outcomes);
    }
}

