/*
 * Decompiled with CFR 0.152.
 */
package org.kie.openrewrite.recipe.jpmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.template.SourceTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPMMLVisitor
extends JavaVisitor<ExecutionContext> {
    private static final Logger logger = LoggerFactory.getLogger(JPMMLVisitor.class);
    static final String JPMML_MODEL_PACKAGE_BASE = "org.jpmml.model";
    static final String DMG_PMML_MODEL_PACKAGE_BASE = "org.dmg.pmml";
    final JavaType.Class originalInstantiatedType;
    final JavaType targetInstantiatedType;
    private static final String FIELD_NAME_FQDN = "org.dmg.pmml.FieldName";
    private static final String MODEL_NAME_FQDN = "org.dmg.pmml.Model";
    private static final String NUMERIC_PREDICTOR_FQDN = "org.dmg.pmml.regression.NumericPredictor";
    private static final String CATEGORICAL_PREDICTOR_FQDN = "org.dmg.pmml.regression.CategoricalPredictor";
    private static final List<String> GET_NAME_TO_GET_FIELD_CLASSES = Arrays.asList("org.dmg.pmml.regression.NumericPredictor", "org.dmg.pmml.regression.CategoricalPredictor");
    private static final String DATADICTIONARY_FQDN = "org.dmg.pmml.DataDictionary";
    private static final Map<String, RemovedListTupla> REMOVED_LIST_FROM_INSTANTIATION = Map.of("org.dmg.pmml.DataDictionary", new RemovedListTupla("addDataFields", JavaType.buildType((String)"org.dmg.pmml.DataField")));
    private static final J.Identifier STRING_IDENTIFIER = new J.Identifier(Tree.randomId(), Space.build((String)" ", Collections.emptyList()), Markers.EMPTY, "String", JavaType.buildType((String)String.class.getCanonicalName()), null);
    private static final J.Identifier PREDICTOR_GET_FIELD_IDENTIFIER = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "getField", (JavaType)JavaType.Primitive.String, null);
    private static final JavaType LIST_JAVA_TYPE = JavaType.buildType((String)List.class.getCanonicalName());
    private static final JavaType.Parameterized LIST_GENERIC_JAVA_TYPE = new JavaType.Parameterized(null, (JavaType.FullyQualified)LIST_JAVA_TYPE, List.of(JavaType.Primitive.String));
    private final JavaTemplate requireMiningFunctionTemplate = JavaTemplate.builder(() -> ((JPMMLVisitor)this).getCursor(), (String)"@Override\n    public MiningFunction requireMiningFunction() {\n        return null;\n    }\n").build();
    private final JavaTemplate requireMiningSchemaTemplate = JavaTemplate.builder(() -> ((JPMMLVisitor)this).getCursor(), (String)"@Override\n    public MiningSchema requireMiningSchema() {\n        return null;\n    }\n").build();

    public JPMMLVisitor(String oldInstantiatedFullyQualifiedTypeName, String newInstantiatedFullyQualifiedTypeName) {
        this.originalInstantiatedType = JavaType.ShallowClass.build((String)oldInstantiatedFullyQualifiedTypeName);
        this.targetInstantiatedType = JavaType.buildType((String)newInstantiatedFullyQualifiedTypeName);
    }

    public J visitBinary(J.Binary binary, ExecutionContext executionContext) {
        logger.trace("visitBinary {}", (Object)binary);
        Expression left = (Expression)super.visitExpression(binary.getLeft(), (Object)executionContext);
        Expression right = (Expression)super.visitExpression(binary.getRight(), (Object)executionContext);
        binary = binary.withLeft(left).withRight(right);
        return super.visitBinary(binary, (Object)executionContext);
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
        if (classDecl.getType() != null && classDecl.getType().getSupertype() != null && MODEL_NAME_FQDN.equals(classDecl.getType().getSupertype().getFullyQualifiedName())) {
            classDecl = this.addMissingMethod(classDecl, "requireMiningFunction", this.requireMiningFunctionTemplate);
            classDecl = this.addMissingMethod(classDecl, "requireMiningSchema", this.requireMiningSchemaTemplate);
        }
        return (J.ClassDeclaration)super.visitClassDeclaration(classDecl, (Object)executionContext);
    }

    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
        logger.trace("visitCompilationUnit {}", (Object)cu);
        String cuName = cu.getSourcePath().toString();
        boolean toMigrate = this.toMigrate(cu.getImports());
        if (!toMigrate) {
            logger.info("Skipping {}", (Object)cuName);
            return cu;
        }
        logger.info("Going to migrate {}", (Object)cuName);
        try {
            cu = (J.CompilationUnit)super.visitCompilationUnit(cu, (Object)executionContext);
            this.maybeAddImport(this.targetInstantiatedType.toString());
            cu = (J.CompilationUnit)new ChangeType(FIELD_NAME_FQDN, String.class.getCanonicalName(), Boolean.valueOf(false)).getVisitor().visitCompilationUnit(cu, (Object)executionContext);
            this.removeFieldNameImport(cu);
            return cu;
        }
        catch (Throwable t) {
            logger.error("Failed to visit {}", (Object)cu, (Object)t);
            return cu;
        }
    }

    public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
        logger.trace("visitMethodInvocation {}", (Object)method);
        if (this.isFieldNameCreate(method)) {
            Expression createArgument = (Expression)method.getArguments().get(0);
            createArgument = (Expression)super.visit((Tree)createArgument, (Object)executionContext);
            return createArgument;
        }
        if (this.useFieldNameGetValue(method)) {
            return method.getSelect();
        }
        if (this.isFieldNameGetNameToGetFieldMapped(method)) {
            JavaType.Method methodType = method.getMethodType().withReturnType((JavaType)JavaType.Primitive.String);
            return method.withName(PREDICTOR_GET_FIELD_IDENTIFIER).withMethodType(methodType);
        }
        if (this.hasFieldNameParameter(method)) {
            JavaType.Method methodType = method.getMethodType().withParameterTypes(Collections.singletonList(JavaType.Primitive.String));
            return method.withMethodType(methodType);
        }
        return super.visitMethodInvocation(method, (Object)executionContext);
    }

    public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
        logger.trace("visitNewClass {}", (Object)newClass);
        Expression toReturn = this.replaceInstantiation(newClass);
        if (toReturn != newClass) {
            return toReturn;
        }
        return super.visitNewClass(newClass, (Object)executionContext);
    }

    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
        logger.trace("visitVariable {}", (Object)variable);
        if (variable.getType() != null && variable.getType().toString().equals(FIELD_NAME_FQDN)) {
            variable = variable.withType((JavaType)JavaType.Primitive.String).withVariableType(variable.getVariableType().withType((JavaType)JavaType.Primitive.String));
        }
        return (J.VariableDeclarations.NamedVariable)super.visitVariable(variable, (Object)executionContext);
    }

    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
        logger.trace("visitVariableDeclarations {}", (Object)multiVariable);
        multiVariable = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)executionContext);
        if (multiVariable.getTypeAsFullyQualified() != null && multiVariable.getTypeAsFullyQualified().getFullyQualifiedName() != null && multiVariable.getTypeAsFullyQualified().getFullyQualifiedName().equals(FIELD_NAME_FQDN)) {
            multiVariable = multiVariable.withType((JavaType)JavaType.Primitive.String).withTypeExpression((TypeTree)STRING_IDENTIFIER);
        }
        return multiVariable;
    }

    protected J.CompilationUnit removeFieldNameImport(J.CompilationUnit cu) {
        if (this.hasFieldNameImport(cu)) {
            ArrayList<J.Import> cleanedImports = new ArrayList<J.Import>();
            for (J.Import imported : cu.getImports()) {
                if (this.isFieldNameImport(imported)) continue;
                cleanedImports.add(imported);
            }
            return cu.withImports(cleanedImports);
        }
        return cu;
    }

    protected boolean hasFieldNameImport(J.CompilationUnit toCheck) {
        return toCheck.getImports().stream().anyMatch(this::isFieldNameImport);
    }

    protected boolean isFieldNameImport(J.Import toCheck) {
        return toCheck.getQualid().getType() instanceof JavaType.Class && ((JavaType.Class)toCheck.getQualid().getType()).getFullyQualifiedName().equals(FIELD_NAME_FQDN);
    }

    protected J.ClassDeclaration addMissingMethod(J.ClassDeclaration classDecl, String searchedMethod, JavaTemplate javaTemplate) {
        if (this.methodExists(classDecl, searchedMethod)) {
            return classDecl;
        }
        classDecl = classDecl.withBody((J.Block)classDecl.getBody().withTemplate((SourceTemplate)javaTemplate, classDecl.getBody().getCoordinates().lastStatement(), new Object[0]));
        return classDecl;
    }

    protected boolean methodExists(J.ClassDeclaration toCheck, String searchedMethod) {
        return toCheck.getBody().getStatements().stream().filter(statement -> statement instanceof J.MethodDeclaration).map(J.MethodDeclaration.class::cast).anyMatch(methodDeclaration -> methodDeclaration.getName().getSimpleName().equals(searchedMethod));
    }

    protected Expression replaceInstantiation(J.NewClass newClass) {
        logger.trace("replaceInstantiation {}", (Object)newClass);
        newClass = this.replaceOriginalToTargetInstantiation(newClass);
        return this.replaceInstantiationListRemoved(newClass);
    }

    protected J.NewClass replaceOriginalToTargetInstantiation(J.NewClass newClass) {
        logger.trace("replaceOriginalToTargetInstantiation {}", (Object)newClass);
        if (newClass.getType() != null && newClass.getType().toString().equals(this.originalInstantiatedType.toString())) {
            JavaType.Method updatedMethod = this.updateMethodToTargetInstantiatedType(newClass.getConstructorType());
            TypeTree typeTree = this.updateTypeTreeToTargetInstantiatedType(newClass);
            newClass = newClass.withConstructorType(updatedMethod).withClazz(typeTree);
        }
        return newClass;
    }

    protected Expression replaceInstantiationListRemoved(J.NewClass newClass) {
        logger.trace("replaceInstantiationListRemoved {}", (Object)newClass);
        Optional<RemovedListTupla> optionalRetrieved = this.getRemovedListTupla(newClass);
        if (optionalRetrieved.isPresent()) {
            RemovedListTupla removedListTupla = optionalRetrieved.get();
            return removedListTupla.getJMethod(newClass);
        }
        return newClass;
    }

    protected Optional<RemovedListTupla> getRemovedListTupla(J.NewClass toCheck) {
        return toCheck.getType() != null && REMOVED_LIST_FROM_INSTANTIATION.containsKey(toCheck.getType().toString()) && toCheck.getArguments() != null && !toCheck.getArguments().isEmpty() && toCheck.getArguments().get(0) instanceof J.Identifier ? Optional.of(REMOVED_LIST_FROM_INSTANTIATION.get(toCheck.getType().toString())) : Optional.empty();
    }

    protected boolean isFieldNameCreate(J.MethodInvocation toCheck) {
        return toCheck.getType() != null && toCheck.getType().toString().equals(FIELD_NAME_FQDN) && toCheck.getName().toString().equals("create");
    }

    protected boolean hasFieldNameParameter(J.MethodInvocation toCheck) {
        return toCheck.getMethodType() != null && toCheck.getMethodType().getParameterTypes() != null && toCheck.getMethodType().getParameterTypes().stream().anyMatch(javaType -> javaType != null && javaType.toString().equals(FIELD_NAME_FQDN));
    }

    protected boolean isFieldNameGetNameToGetFieldMapped(J.MethodInvocation toCheck) {
        return toCheck.getMethodType() != null && toCheck.getMethodType().getDeclaringType() != null && GET_NAME_TO_GET_FIELD_CLASSES.contains(toCheck.getMethodType().getDeclaringType().toString()) && toCheck.getName().toString().equals("getName");
    }

    protected boolean useFieldNameGetValue(J.MethodInvocation toCheck) {
        return toCheck.getMethodType() != null && toCheck.getMethodType().getDeclaringType() != null && toCheck.getMethodType().getDeclaringType().getFullyQualifiedName() != null && toCheck.getMethodType().getDeclaringType().getFullyQualifiedName().equals(FIELD_NAME_FQDN) && toCheck.getMethodType().getName().equals("getValue");
    }

    protected boolean toMigrate(List<J.Import> imports) {
        return imports.stream().anyMatch(anImport -> anImport.getPackageName().startsWith(JPMML_MODEL_PACKAGE_BASE) || anImport.getPackageName().startsWith(DMG_PMML_MODEL_PACKAGE_BASE));
    }

    protected JavaType.Method updateMethodToTargetInstantiatedType(JavaType.Method oldMethodType) {
        if (oldMethodType != null) {
            JavaType.Method method = oldMethodType;
            method = method.withDeclaringType((JavaType.FullyQualified)this.targetInstantiatedType).withReturnType(this.targetInstantiatedType);
            return method;
        }
        return null;
    }

    protected TypeTree updateTypeTreeToTargetInstantiatedType(J.NewClass newClass) {
        return ((J.Identifier)newClass.getClazz()).withSimpleName(((JavaType.ShallowClass)this.targetInstantiatedType).getClassName()).withType(this.targetInstantiatedType);
    }

    static class RemovedListTupla {
        private final String addMethodName;
        private final J.Identifier elementIdentifier;
        private final JavaType.Array elementArray;
        private final J.Identifier elementToArrayIdentifier;
        private final J.Identifier addMethodIdentifier;

        public RemovedListTupla(String addMethodName, JavaType elementJavaType) {
            this.addMethodName = addMethodName;
            this.elementIdentifier = new J.Identifier(Tree.randomId(), Space.build((String)" ", Collections.emptyList()), Markers.EMPTY, elementJavaType.toString(), elementJavaType, null);
            this.elementArray = new JavaType.Array(null, elementJavaType);
            JavaType.Parameterized elementListJavaType = new JavaType.Parameterized(null, (JavaType.FullyQualified)LIST_JAVA_TYPE, List.of(elementJavaType));
            this.elementToArrayIdentifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "toArray", (JavaType)elementListJavaType, null);
            this.addMethodIdentifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, addMethodName, (JavaType)elementListJavaType, null);
        }

        public J.MethodInvocation getJMethod(J.NewClass newClass) {
            J.Identifier originalListIdentifier = (J.Identifier)newClass.getArguments().get(0);
            J.Literal literal = new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)0, "0", null, JavaType.Primitive.Int);
            J.ArrayDimension arrayDimension = new J.ArrayDimension(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)literal));
            J.NewArray newArray = new J.NewArray(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (TypeTree)this.elementIdentifier, Collections.singletonList(arrayDimension), null, (JavaType)this.elementArray);
            JavaType.Method methodType = new JavaType.Method(null, 1025L, (JavaType.FullyQualified)LIST_GENERIC_JAVA_TYPE, "toArray", (JavaType)this.elementArray, Collections.singletonList("arg0"), Collections.singletonList(this.elementArray), null, null);
            J.MethodInvocation toArrayInvocation = new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, null, this.elementToArrayIdentifier, JContainer.build(Collections.emptyList()), methodType).withSelect((Expression)originalListIdentifier).withArguments(Collections.singletonList(newArray));
            JavaType.Method constructorType = newClass.getConstructorType().withParameterTypes(Collections.emptyList()).withParameterNames(Collections.emptyList());
            J.NewClass noArgClass = newClass.withArguments(Collections.emptyList()).withConstructorType(constructorType);
            JavaType.Method addMethodInvocation = new JavaType.Method(null, 1025L, (JavaType.FullyQualified)JavaType.buildType((String)noArgClass.getType().toString()), this.addMethodName, (JavaType)JavaType.Primitive.Void, Collections.singletonList("toAdd"), Collections.singletonList(this.elementArray), null, null);
            return new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, null, this.addMethodIdentifier, JContainer.build(Collections.emptyList()), addMethodInvocation).withSelect((Expression)noArgClass).withArguments(Collections.singletonList(toArrayInvocation));
        }
    }
}

