/*
 * Decompiled with CFR 0.152.
 */
package org.kie.openrewrite.recipe.jpmml;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.Java11Parser;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class CommonTestingUtilities {
    private static final List<Path> paths = JavaParser.runtimeClasspath();

    private CommonTestingUtilities() {
    }

    public static J.CompilationUnit getCompilationUnitFromClassSource(String classSource) {
        Java11Parser parser = ((Java11Parser.Builder)((Java11Parser.Builder)Java11Parser.builder().classpath(paths)).logCompilationWarningsAndErrors(true)).build();
        return (J.CompilationUnit)parser.parse(new String[]{classSource}).get(0);
    }

    public static Optional<J.Binary> getBinaryFromClassSource(String classSource, String binaryString) {
        J.CompilationUnit compilationUnit = CommonTestingUtilities.getCompilationUnitFromClassSource(classSource);
        TestingVisitor testingVisitor = new TestingVisitor(J.Binary.class, binaryString);
        testingVisitor.visit((Tree)compilationUnit, CommonTestingUtilities.getExecutionContext(null));
        return testingVisitor.getFoundItem();
    }

    public static Optional<J.ClassDeclaration> getClassDeclarationFromClassSource(String classSource, String className) {
        J.CompilationUnit compilationUnit = CommonTestingUtilities.getCompilationUnitFromClassSource(classSource);
        TestingVisitor testingVisitor = new TestingVisitor(J.ClassDeclaration.class, className);
        testingVisitor.visit((Tree)compilationUnit, CommonTestingUtilities.getExecutionContext(null));
        return testingVisitor.getFoundItem();
    }

    public static Optional<J.ClassDeclaration> getClassDeclarationFromCompilationUnit(J.CompilationUnit compilationUnit, String className) {
        TestingVisitor testingVisitor = new TestingVisitor(J.ClassDeclaration.class, className);
        testingVisitor.visit((Tree)compilationUnit, CommonTestingUtilities.getExecutionContext(null));
        return testingVisitor.getFoundItem();
    }

    public static Optional<J.MethodInvocation> getMethodInvocationFromClassSource(String classSource, String methodInvocation) {
        J.CompilationUnit compilationUnit = CommonTestingUtilities.getCompilationUnitFromClassSource(classSource);
        TestingVisitor testingVisitor = new TestingVisitor(J.MethodInvocation.class, methodInvocation);
        testingVisitor.visit((Tree)compilationUnit, CommonTestingUtilities.getExecutionContext(null));
        return testingVisitor.getFoundItem();
    }

    public static Optional<J.NewClass> getNewClassFromClassSource(String classSource, String fqdnInstantiatedClass) {
        J.CompilationUnit compilationUnit = CommonTestingUtilities.getCompilationUnitFromClassSource(classSource);
        TestingVisitor testingVisitor = new TestingVisitor(J.NewClass.class, fqdnInstantiatedClass);
        testingVisitor.visit((Tree)compilationUnit, CommonTestingUtilities.getExecutionContext(null));
        return testingVisitor.getFoundItem();
    }

    public static Optional<J.VariableDeclarations> getVariableDeclarationsFromClassSource(String classSource, String variableDeclaration) {
        J.CompilationUnit compilationUnit = CommonTestingUtilities.getCompilationUnitFromClassSource(classSource);
        TestingVisitor testingVisitor = new TestingVisitor(J.VariableDeclarations.class, variableDeclaration);
        testingVisitor.visit((Tree)compilationUnit, CommonTestingUtilities.getExecutionContext(null));
        return testingVisitor.getFoundItem();
    }

    public static Optional<Expression> getExpressionFromClassSource(String classSource, String expression) {
        J.CompilationUnit compilationUnit = CommonTestingUtilities.getCompilationUnitFromClassSource(classSource);
        TestingVisitor testingVisitor = new TestingVisitor(Expression.class, expression);
        testingVisitor.visit((Tree)compilationUnit, CommonTestingUtilities.getExecutionContext(null));
        return testingVisitor.getFoundItem();
    }

    public static Optional<Expression> getExpressionFromCompilationUnit(J.CompilationUnit compilationUnit, String expression) {
        TestingVisitor testingVisitor = new TestingVisitor(Expression.class, expression);
        testingVisitor.visit((Tree)compilationUnit, CommonTestingUtilities.getExecutionContext(null));
        return testingVisitor.getFoundItem();
    }

    public static List<J.Import> getImportsFromClassSource(String classSource) {
        J.CompilationUnit compilationUnit = CommonTestingUtilities.getCompilationUnitFromClassSource(classSource);
        return compilationUnit.getImports();
    }

    public static ExecutionContext getExecutionContext(Throwable expected) {
        return new InMemoryExecutionContext(throwable -> Assertions.assertThat((Throwable)throwable).isEqualTo((Object)expected));
    }

    private static class TestingVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Class<? extends J> SEARCHED_J;
        private final String SEARCHED_STRING;
        private Optional<? extends J> foundItem;

        public TestingVisitor(Class<? extends J> SEARCHED_J, String SEARCHED_STRING) {
            this.SEARCHED_J = SEARCHED_J;
            this.SEARCHED_STRING = SEARCHED_STRING;
            this.foundItem = Optional.empty();
        }

        public Optional<? extends J> getFoundItem() {
            return this.foundItem;
        }

        public J.Binary visitBinary(J.Binary binary, ExecutionContext executionContext) {
            if (this.SEARCHED_J.equals(J.Binary.class) && binary.toString().equals(this.SEARCHED_STRING)) {
                this.foundItem = Optional.of(binary);
                return binary;
            }
            return super.visitBinary(binary, (Object)executionContext);
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            if (this.SEARCHED_J.equals(J.CompilationUnit.class)) {
                this.foundItem = Optional.of(cu);
                return cu;
            }
            return super.visitCompilationUnit(cu, (Object)executionContext);
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            if (this.SEARCHED_J.equals(J.ClassDeclaration.class) && classDecl.getSimpleName().equals(this.SEARCHED_STRING)) {
                this.foundItem = Optional.of(classDecl);
                return classDecl;
            }
            return super.visitClassDeclaration(classDecl, (Object)executionContext);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (this.SEARCHED_J.equals(J.MethodInvocation.class) && method.toString().startsWith(this.SEARCHED_STRING + "(")) {
                this.foundItem = Optional.of(method);
                return method;
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }

        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            if (this.SEARCHED_J.equals(J.NewClass.class) && newClass.getType().toString().equals(this.SEARCHED_STRING)) {
                this.foundItem = Optional.of(newClass);
                return newClass;
            }
            return super.visitNewClass(newClass, (Object)executionContext);
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
            if (this.SEARCHED_J.equals(J.VariableDeclarations.class) && multiVariable.toString().startsWith(this.SEARCHED_STRING)) {
                this.foundItem = Optional.of(multiVariable);
                return multiVariable;
            }
            return super.visitVariableDeclarations(multiVariable, (Object)executionContext);
        }

        public Expression visitExpression(Expression expression, ExecutionContext executionContext) {
            if (this.SEARCHED_J.equals(Expression.class) && expression.toString().equals(this.SEARCHED_STRING)) {
                this.foundItem = Optional.of(expression);
                return expression;
            }
            return super.visitExpression(expression, (Object)executionContext);
        }
    }
}

