/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.net.URL;
import java.util.ArrayList;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.aries.blueprint.KieBlueprintContainer;
import org.kie.aries.blueprint.factorybeans.KieObjectsResolver;
import org.osgi.service.blueprint.container.ComponentDefinitionException;

public class KieBlueprintBasicTests {
    static BlueprintContainerImpl container = null;

    @BeforeClass
    public static void setup() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(KieBlueprintBasicTests.class.getResource("/org/kie/aries/blueprint/basics.xml"));
        container = new KieBlueprintContainer(ClassLoader.getSystemClassLoader(), urls);
    }

    @Test
    public void testReleaseId() throws Exception {
        Object obj = container.getComponentInstance("dummyReleaseId");
        Assert.assertNotNull((Object)obj);
        Assert.assertTrue((boolean)(obj instanceof ReleaseId));
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)container.getComponentInstance("drl_kiesample");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testKieStore() throws Exception {
        KieStoreServices sampleKstore = (KieStoreServices)container.getComponentInstance("sampleKstore");
        Assert.assertNotNull((Object)sampleKstore);
    }

    @Test
    public void testKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("ksession9");
        System.out.println(ksession);
        Assert.assertNotNull((Object)ksession);
    }

    @Test
    public void testKieSessionRef() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("ksession1");
        System.out.println(ksession);
        Assert.assertNotNull((Object)ksession);
        KieObjectsResolver kieObjectsResolver = KieObjectsResolver.get();
        Object obj = kieObjectsResolver.resolveKSession("ksession1", null);
        Assert.assertSame((Object)ksession, (Object)obj);
    }

    @Test
    public void testInvalidKieSessionRef() throws Exception {
        try {
            StatelessKieSession ksession = (StatelessKieSession)container.getComponentInstance("should-fail-ksession1");
            Assert.assertNull((Object)ksession);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ComponentDefinitionException));
            return;
        }
        Assert.fail();
    }

    @AfterClass
    public static void tearDown() {
        container.destroy();
    }
}

