/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.net.URL;
import java.util.ArrayList;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.drools.core.audit.ThreadedWorkingMemoryFileLogger;
import org.drools.core.audit.WorkingMemoryConsoleLogger;
import org.drools.core.audit.WorkingMemoryFileLogger;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.aries.blueprint.KieBlueprintContainer;
import org.kie.aries.blueprint.beans.Person;
import org.kie.aries.blueprint.factorybeans.KieLoggerAdaptor;
import org.kie.aries.blueprint.tests.KieBlueprintListenerTest;

public class KieBlueprintLoggerTest {
    static BlueprintContainerImpl container = null;

    @BeforeClass
    public static void runBeforeClass() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(KieBlueprintListenerTest.class.getResource("/org/kie/aries/blueprint/loggers.xml"));
        container = new KieBlueprintContainer(ClassLoader.getSystemClassLoader(), urls);
    }

    @AfterClass
    public static void runAfterClass() {
        container.destroy();
    }

    @Test
    public void testStatelessSessionRefConsoleLogger() throws Exception {
        StatelessKieSession session = (StatelessKieSession)container.getComponentInstance("loggerSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)session;
        KieLoggerAdaptor kieLoggerAdaptor = (KieLoggerAdaptor)container.getComponentInstance("ConsoleSessionLogger");
        Assert.assertNotNull((Object)kieLoggerAdaptor);
        Assert.assertNotNull((Object)kieLoggerAdaptor.getRuntimeLogger());
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryConsoleLogger));
        }
    }

    @Test
    public void testStatefulKnowledgeConsoleLogger() throws Exception {
        KieSession statefulSession = (KieSession)container.getComponentInstance("ConsoleLogger-statefulSession");
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryConsoleLogger));
        }
    }

    @Test
    public void testStatefulKnowledgeFileLogger() throws Exception {
        KieSession statefulSession = (KieSession)container.getComponentInstance("FileLogger-statefulSession");
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
        KieLoggerAdaptor adaptor = (KieLoggerAdaptor)container.getComponentInstance("sf_fl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatefulKnowledgeThreadedFileLogger() throws Exception {
        KieSession statefulSession = (KieSession)container.getComponentInstance("ThreadedFileLogger-statefulSession");
        StatefulKnowledgeSessionImpl impl = (StatefulKnowledgeSessionImpl)statefulSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof ThreadedWorkingMemoryFileLogger));
        }
        KieLoggerAdaptor adaptor = (KieLoggerAdaptor)container.getComponentInstance("sf_tfl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatelessKnowledgeConsoleLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)container.getComponentInstance("ConsoleLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryConsoleLogger));
        }
    }

    @Test
    public void testStatelessKnowledgeFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)container.getComponentInstance("FileLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
        KieLoggerAdaptor adaptor = (KieLoggerAdaptor)container.getComponentInstance("ss_fl_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatelessKnowledgeThreadedFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)container.getComponentInstance("ThreadedFileLogger-statelessSession");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof ThreadedWorkingMemoryFileLogger));
        }
        KieLoggerAdaptor loggerAdaptor = (KieLoggerAdaptor)container.getComponentInstance("ss_tfl_logger");
        Assert.assertNotNull((Object)loggerAdaptor);
        Assert.assertNotNull((Object)loggerAdaptor.getRuntimeLogger());
        loggerAdaptor.close();
    }

    @Test
    public void testSessionLoggersFromGroupAndNested() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)container.getComponentInstance("k1");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        Assert.assertEquals((long)2L, (long)impl.getRuleRuntimeEventListeners().size());
        ArrayList list = new ArrayList();
        statelessKnowledgeSession.setGlobal("persons", list);
        Assert.assertNotNull((Object)statelessKnowledgeSession.getGlobals().get("persons"));
        statelessKnowledgeSession.execute((Object)new Person("Darth", "Cheddar", 50));
        KieLoggerAdaptor adaptor = (KieLoggerAdaptor)container.getComponentInstance("k1_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
        adaptor.close();
        adaptor = (KieLoggerAdaptor)container.getComponentInstance("k1_console_logger");
        Assert.assertNotNull((Object)adaptor);
        Assert.assertNotNull((Object)adaptor.getRuntimeLogger());
    }

    @Test
    public void testStatelessNoNameFileLogger() throws Exception {
        StatelessKieSession statelessKnowledgeSession = (StatelessKieSession)container.getComponentInstance("FileLogger-statelessSession-noNameLogger");
        StatelessKnowledgeSessionImpl impl = (StatelessKnowledgeSessionImpl)statelessKnowledgeSession;
        for (Object listener : impl.getRuleRuntimeEventListeners()) {
            Assert.assertTrue((boolean)(listener instanceof WorkingMemoryFileLogger));
        }
    }
}

