/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.tests;

import java.net.URL;
import java.util.ArrayList;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.aries.blueprint.KieBlueprintContainer;
import org.kie.aries.blueprint.beans.Person;

public class KieBlueprintCommandsTest {
    static BlueprintContainerImpl container = null;

    @BeforeClass
    public static void runBeforeClass() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(KieBlueprintCommandsTest.class.getResource("/org/kie/aries/blueprint/beans-commands.xml"));
        container = new KieBlueprintContainer(ClassLoader.getSystemClassLoader(), urls);
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)container.getComponentInstance("drl_kiesample");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testInsertObject() throws Exception {
        KieSession ksession = (KieSession)container.getComponentInstance("ksession2");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertFalse((boolean)((Person)object).isHappy());
        }
        ksession.fireAllRules();
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
    }

    @Test
    public void testInsertObjectAndFireAll() throws Exception {
        KieSession ksession = (KieSession)container.getComponentInstance("ksessionForCommands");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
    }

    @Test
    public void testSetGlobals() throws Exception {
        KieSession ksession = (KieSession)container.getComponentInstance("ksessionForCommands");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        Person p1 = (Person)ksession.getObjects().toArray()[0];
        Assert.assertNotNull((Object)p1);
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
        Object list = ksession.getGlobal("persons");
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((boolean)(list instanceof ArrayList));
        Assert.assertEquals((long)1L, (long)((ArrayList)list).size());
        Person p = (Person)((ArrayList)list).get(0);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)p, (Object)p1);
    }

    @AfterClass
    public static void tearDown() {
        container.destroy();
    }
}

