/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.component;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.bind.Marshaller;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.io.KieResources;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.camel.component.KieCamelTestSupport;
import org.kie.camel.component.KiePolicy;
import org.kie.internal.builder.JaxbConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;

public class CamelEndpointWithJaxbXSDModelTest
extends KieCamelTestSupport {
    private ClassLoader classLoader;

    @Test
    public void testSessionInsert() throws Exception {
        Class<?> personClass = this.classLoader.loadClass("org.drools.model.Person");
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)personClass.getPackage());
        Class<?> addressClass = this.classLoader.loadClass("org.drools.model.AddressType");
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)addressClass.getPackage());
        Object baunax = personClass.newInstance();
        Object lucaz = personClass.newInstance();
        Method setName = personClass.getMethod("setName", String.class);
        setName.invoke(baunax, "baunax");
        setName.invoke(lucaz, "lucaz");
        Method setAddress = personClass.getMethod("setAddress", addressClass);
        Method setStreet = addressClass.getMethod("setStreet", String.class);
        Method setPostalCode = addressClass.getMethod("setPostalCode", BigInteger.class);
        Object lucazAddress = addressClass.newInstance();
        setStreet.invoke(lucazAddress, "Unknow 342");
        setPostalCode.invoke(lucazAddress, new BigInteger("1234"));
        Object baunaxAddress = addressClass.newInstance();
        setStreet.invoke(baunaxAddress, "New Street 123");
        setPostalCode.invoke(baunaxAddress, new BigInteger("5678"));
        setAddress.invoke(lucaz, lucazAddress);
        setAddress.invoke(baunax, baunaxAddress);
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        cmd.getCommands().add(new InsertObjectCommand(lucaz, "lucaz"));
        cmd.getCommands().add(new InsertObjectCommand(baunax, "baunax"));
        cmd.getCommands().add(new FireAllRulesCommand());
        StringWriter xmlReq = new StringWriter();
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)cmd, (Writer)xmlReq);
        System.out.println(xmlReq.toString());
        String xmlCmd = "";
        xmlCmd = xmlCmd + "<batch-execution lookup='ksession1'>\n";
        xmlCmd = xmlCmd + "   <insert out-identifier='lucaz'>\n";
        xmlCmd = xmlCmd + "    <object>\n";
        xmlCmd = xmlCmd + "      <Person xmlns='http://drools.org/model' >\n";
        xmlCmd = xmlCmd + "         <name>lucaz</name>\n";
        xmlCmd = xmlCmd + "         <age>25</age>\n";
        xmlCmd = xmlCmd + "      </Person>\n";
        xmlCmd = xmlCmd + "    </object>\n";
        xmlCmd = xmlCmd + "   </insert>\n";
        xmlCmd = xmlCmd + "   <insert out-identifier='baunax'>\n";
        xmlCmd = xmlCmd + "    <object>\n";
        xmlCmd = xmlCmd + "      <Person xmlns='http://drools.org/model' >\n";
        xmlCmd = xmlCmd + "         <name>baunax</name>\n";
        xmlCmd = xmlCmd + "         <age>21</age>\n";
        xmlCmd = xmlCmd + "      </Person>\n";
        xmlCmd = xmlCmd + "    </object>\n";
        xmlCmd = xmlCmd + "   </insert>\n";
        xmlCmd = xmlCmd + "   <fire-all-rules />";
        xmlCmd = xmlCmd + "</batch-execution>\n";
        byte[] xmlResp = (byte[])this.template.requestBody("direct:test-with-session", (Object)xmlReq.toString());
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)xmlResp);
        System.out.println(new String(xmlResp));
        ExecutionResults resp = (ExecutionResults)this.getJaxbContext().createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xmlResp));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxbXSDModelTest.assertEquals((long)2L, (long)resp.getIdentifiers().size());
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getValue("lucaz"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getValue("baunax"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getFactHandle("lucaz"));
        CamelEndpointWithJaxbXSDModelTest.assertNotNull((Object)resp.getFactHandle("baunax"));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        this.routeBuilder = new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat def = new JaxbDataFormat();
                def.setPrettyPrint(Boolean.valueOf(true));
                def.setContextPath("org.kie.pipeline.camel");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session").policy((Policy)new KiePolicy()).unmarshal((DataFormatDefinition)def)).to("kie:ksession1")).marshal((DataFormatDefinition)def);
            }
        };
        return this.routeBuilder;
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        String rule = "";
        rule = rule + "package org.kie.pipeline.camel.test \n";
        rule = rule + "import org.drools.model.Person \n";
        rule = rule + "global java.util.List list \n";
        rule = rule + "query persons \n";
        rule = rule + "   $p : Person(name != null) \n";
        rule = rule + "end \n";
        rule = rule + "query personWithName(String param)\n";
        rule = rule + "   $p : Person(name == param) \n";
        rule = rule + "end \n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() \n";
        rule = rule + " \n";
        rule = rule + "  then \n";
        rule = rule + "    System.out.println(\"executed\"); \n";
        rule = rule + "end\n";
        this.registerKnowledgeRuntime("ksession1", rule);
    }

    @Override
    protected KieSession registerKnowledgeRuntime(String identifier, String rule) {
        KieBuilder kieBuilder;
        List errors;
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieResources kieResources = ks.getResources();
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        JaxbConfiguration jaxbConfiguration = KnowledgeBuilderFactory.newJaxbConfiguration((Options)xjcOpts, (String)"xsd");
        kfs.write(kieResources.newClassPathResource("person.xsd", ((Object)((Object)this)).getClass()).setResourceType(ResourceType.XSD).setConfiguration((ResourceConfiguration)jaxbConfiguration));
        if (rule != null && rule.length() > 0) {
            kfs.write("src/main/resources/rule.drl", rule);
        }
        if (!(errors = (kieBuilder = ks.newKieBuilder(kfs).buildAll()).getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).isEmpty()) {
            CamelEndpointWithJaxbXSDModelTest.fail((String)("" + errors));
        }
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        this.classLoader = ((InternalRuleBase)((KnowledgeBaseImpl)ksession.getKieBase()).getRuleBase()).getRootClassLoader();
        try {
            this.jndiContext.bind(identifier, (Object)ksession);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return ksession;
    }
}

