/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.camel.component;

import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieSession;
import org.kie.camel.embedded.component.KiePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieCamelTestSupport
extends CamelTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(KieCamelTestSupport.class);
    protected Context jndiContext;
    protected JAXBContext jaxbContext;
    protected RouteBuilder routeBuilder;

    public void setUp() throws Exception {
        super.setUp();
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    protected Context createJndiContext() throws Exception {
        this.jndiContext = super.createJndiContext();
        this.configureDroolsContext(this.jndiContext);
        return this.jndiContext;
    }

    protected abstract void configureDroolsContext(Context var1);

    protected KieSession registerKnowledgeRuntime(String identifier, String rule) {
        KieBuilder kieBuilder;
        List errors;
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieResources kieResources = ks.getResources();
        if (rule != null && rule.length() > 0) {
            kfs.write("src/main/resources/rule.drl", rule);
        }
        if (!(errors = (kieBuilder = ks.newKieBuilder(kfs).buildAll()).getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).isEmpty()) {
            KieCamelTestSupport.fail((String)("" + errors));
        }
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        try {
            this.jndiContext.bind(identifier, (Object)ksession);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return ksession;
    }

    protected void assertXMLEqual(String expected, String result) throws Exception {
        Diff diff = new Diff(expected, result);
        diff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
        XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
    }

    protected void configureDroolsContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            JaxbDataFormat def = new JaxbDataFormat();
            def.setPrettyPrint(Boolean.valueOf(true));
            def.setContextPath("org.drools.model:org.kie.pipeline.camel");
            KieSession ksession1 = null;
            try {
                ksession1 = (KieSession)this.jndiContext.lookup("ksession1");
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            KieBase kbase = ksession1.getKieBase();
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((KnowledgeBaseImpl)kbase).getRootClassLoader());
                this.routeBuilder.getContext().setApplicationContextClassLoader(((KnowledgeBaseImpl)kbase).getRootClassLoader());
                def = KiePolicy.augmentJaxbDataFormatDefinition((JaxbDataFormat)def);
                org.apache.camel.converter.jaxb.JaxbDataFormat jaxbDataformat = (org.apache.camel.converter.jaxb.JaxbDataFormat)def.getDataFormat(((Route)this.context.getRoutes().get(0)).getRouteContext());
                jaxbDataformat.setCamelContext((CamelContext)this.routeBuilder.getContext());
                try {
                    jaxbDataformat.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                this.jaxbContext = jaxbDataformat.getContext();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        return this.jaxbContext;
    }
}

