/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution.scope.internal;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.util.Providers;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.execution.scope.WeakMojoExecutionListener;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Named
@Singleton
public class MojoExecutionScope
implements Scope,
MojoExecutionListener {
    private static final Provider<Object> SEEDED_KEY_PROVIDER = new Provider<Object>(){

        @Override
        public Object get() {
            throw new IllegalStateException();
        }
    };
    private final ThreadLocal<LinkedList<ScopeState>> values = new ThreadLocal();

    public void enter() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null) {
            stack = new LinkedList();
            this.values.set(stack);
        }
        stack.addFirst(new ScopeState());
    }

    private ScopeState getScopeState() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        return stack.getFirst();
    }

    public void exit() throws MojoExecutionException {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        stack.removeFirst();
        if (stack.isEmpty()) {
            this.values.remove();
        }
    }

    public <T> void seed(Class<T> clazz, Provider<T> value) {
        this.getScopeState().seeded.put(Key.get(clazz), value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.getScopeState().seeded.put(Key.get(clazz), Providers.of(value));
    }

    @Override
    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            @Override
            public T get() {
                LinkedList stack = (LinkedList)MojoExecutionScope.this.values.get();
                if (stack == null || stack.isEmpty()) {
                    throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
                }
                ScopeState state = (ScopeState)stack.getFirst();
                Provider<?> seeded = state.seeded.get(key);
                if (seeded != null) {
                    return seeded.get();
                }
                Object provided = state.provided.get(key);
                if (provided == null && unscoped != null) {
                    provided = unscoped.get();
                    state.provided.put(key, provided);
                }
                return provided;
            }
        };
    }

    public static <T> Provider<T> seededKeyProvider() {
        return SEEDED_KEY_PROVIDER;
    }

    public static Module getScopeModule(PlexusContainer container) throws ComponentLookupException {
        final MojoExecutionScope scope = container.lookup(MojoExecutionScope.class);
        return new AbstractModule(){

            @Override
            protected void configure() {
                this.bindScope(MojoExecutionScoped.class, scope);
                this.bind(MavenProject.class).toProvider(MojoExecutionScope.seededKeyProvider()).in(scope);
                this.bind(MojoExecution.class).toProvider(MojoExecutionScope.seededKeyProvider()).in(scope);
            }
        };
    }

    @Override
    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
        for (Object provided : this.getScopeState().provided.values()) {
            if (!(provided instanceof WeakMojoExecutionListener)) continue;
            ((WeakMojoExecutionListener)provided).beforeMojoExecution(event);
        }
    }

    @Override
    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
        for (Object provided : this.getScopeState().provided.values()) {
            if (!(provided instanceof WeakMojoExecutionListener)) continue;
            ((WeakMojoExecutionListener)provided).afterMojoExecutionSuccess(event);
        }
    }

    @Override
    public void afterExecutionFailure(MojoExecutionEvent event) {
        for (Object provided : this.getScopeState().provided.values()) {
            if (!(provided instanceof WeakMojoExecutionListener)) continue;
            ((WeakMojoExecutionListener)provided).afterExecutionFailure(event);
        }
    }

    private static final class ScopeState {
        public final Map<Key<?>, Provider<?>> seeded = Maps.newHashMap();
        public final Map<Key<?>, Object> provided = Maps.newHashMap();

        private ScopeState() {
        }
    }
}

