/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.version.Version;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.Aether;
import org.kie.scanner.DependencyDescriptor;
import org.kie.scanner.embedder.MavenSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepository {
    private static final Logger log = LoggerFactory.getLogger(MavenRepository.class);
    private static MavenRepository defaultMavenRepository;
    private final Aether aether;
    private final Collection<RemoteRepository> extraRepositories;
    private final Collection<RemoteRepository> remoteRepositoriesForRequest;

    protected MavenRepository(Aether aether) {
        this.aether = aether;
        Settings settings = this.getSettings();
        this.extraRepositories = this.initExtraRepositories(settings);
        this.remoteRepositoriesForRequest = this.initRemoteRepositoriesForRequest(settings);
    }

    protected Settings getSettings() {
        return MavenSettings.getSettings();
    }

    Collection<RemoteRepository> getRemoteRepositoriesForRequest() {
        return this.remoteRepositoriesForRequest;
    }

    public static synchronized MavenRepository getMavenRepository() {
        if (defaultMavenRepository == null) {
            Aether defaultAether = Aether.getAether();
            defaultMavenRepository = new MavenRepository(defaultAether);
        }
        return defaultMavenRepository;
    }

    private Collection<RemoteRepository> initExtraRepositories(Settings settings) {
        HashSet<RemoteRepository> extraRepositories = new HashSet<RemoteRepository>();
        for (Profile profile : settings.getProfiles()) {
            if (!this.isProfileActive(settings, profile)) continue;
            for (Repository repository : profile.getRepositories()) {
                extraRepositories.add(MavenRepository.toRemoteRepositoryBuilder(settings, repository).build());
            }
            for (Repository repository : profile.getPluginRepositories()) {
                extraRepositories.add(MavenRepository.toRemoteRepositoryBuilder(settings, repository).build());
            }
        }
        return extraRepositories;
    }

    private Collection<RemoteRepository> initRemoteRepositoriesForRequest(Settings settings) {
        HashSet<RemoteRepository> remoteRepos = new HashSet<RemoteRepository>();
        for (RemoteRepository repo : this.extraRepositories) {
            remoteRepos.add(this.resolveMirroredRepo(settings, repo));
        }
        for (RemoteRepository repo : this.aether.getRepositories()) {
            remoteRepos.add(this.resolveMirroredRepo(settings, repo));
        }
        return remoteRepos;
    }

    private RemoteRepository resolveMirroredRepo(Settings settings, RemoteRepository repo) {
        for (Mirror mirror : settings.getMirrors()) {
            if (!this.isMirror(repo, mirror.getMirrorOf())) continue;
            return MavenRepository.toRemoteRepositoryBuilder(settings, mirror.getId(), mirror.getLayout(), mirror.getUrl()).build();
        }
        return repo;
    }

    private boolean isMirror(RemoteRepository repo, String mirrorOf) {
        return mirrorOf.equals("*") || mirrorOf.equals("external:*") && !repo.getUrl().startsWith("file:") || mirrorOf.contains("external:*") && !repo.getUrl().startsWith("file:") && !mirrorOf.contains("!" + repo.getId()) || mirrorOf.startsWith("*") && !mirrorOf.contains("!" + repo.getId()) || !mirrorOf.startsWith("*") && !mirrorOf.contains("external:*") && mirrorOf.contains(repo.getId());
    }

    private boolean isProfileActive(Settings settings, Profile profile) {
        return settings.getActiveProfiles().contains(profile.getId()) || profile.getActivation() != null && profile.getActivation().isActiveByDefault();
    }

    private static RemoteRepository.Builder toRemoteRepositoryBuilder(Settings settings, Repository repository) {
        RemoteRepository.Builder remoteBuilder = MavenRepository.toRemoteRepositoryBuilder(settings, repository.getId(), repository.getLayout(), repository.getUrl());
        MavenRepository.setPolicy(remoteBuilder, repository.getSnapshots(), true);
        MavenRepository.setPolicy(remoteBuilder, repository.getReleases(), false);
        return remoteBuilder;
    }

    private static RemoteRepository.Builder toRemoteRepositoryBuilder(Settings settings, String id, String layout, String url) {
        RemoteRepository.Builder remoteBuilder = new RemoteRepository.Builder(id, layout, url);
        Server server = settings.getServer(id);
        if (server != null) {
            remoteBuilder.setAuthentication(new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).build());
        }
        return remoteBuilder;
    }

    private static void setPolicy(RemoteRepository.Builder builder, org.apache.maven.settings.RepositoryPolicy policy, boolean snapshot) {
        if (policy != null) {
            RepositoryPolicy repoPolicy = new RepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
            if (snapshot) {
                builder.setSnapshotPolicy(repoPolicy);
            } else {
                builder.setReleasePolicy(repoPolicy);
            }
        }
    }

    public static MavenRepository getMavenRepository(MavenProject mavenProject) {
        return new MavenRepository(new Aether(mavenProject));
    }

    public List<DependencyDescriptor> getArtifactDependecies(String artifactName) {
        CollectResult collectResult;
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        CollectRequest collectRequest = new CollectRequest();
        Dependency root = new Dependency(artifact, "");
        collectRequest.setRoot(root);
        for (RemoteRepository repo : this.remoteRepositoriesForRequest) {
            collectRequest.addRepository(repo);
        }
        try {
            collectResult = this.aether.getSystem().collectDependencies(this.aether.getSession(), collectRequest);
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(e);
        }
        CollectDependencyVisitor visitor = new CollectDependencyVisitor();
        collectResult.getRoot().accept(visitor);
        ArrayList<DependencyDescriptor> descriptors = new ArrayList<DependencyDescriptor>();
        for (DependencyNode node : visitor.getDependencies()) {
            if (node.getDependency().equals(root)) continue;
            descriptors.add(new DependencyDescriptor(node.getDependency().getArtifact()));
        }
        return descriptors;
    }

    public Artifact resolveArtifact(ReleaseId releaseId) {
        String artifactName = releaseId.toString();
        if (DependencyDescriptor.isRangedVersion(releaseId.getVersion())) {
            Version v = this.resolveVersion(artifactName);
            if (v == null) {
                return null;
            }
            artifactName = releaseId.getGroupId() + ":" + releaseId.getArtifactId() + ":" + v;
        }
        return this.resolveArtifact(artifactName);
    }

    public Artifact resolveArtifact(String artifactName) {
        return this.resolveArtifact(artifactName, true);
    }

    public Artifact resolveArtifact(String artifactName, boolean logUnresolvedArtifact) {
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        for (RemoteRepository repo : this.remoteRepositoriesForRequest) {
            artifactRequest.addRepository(repo);
        }
        try {
            ArtifactResult artifactResult = this.aether.getSystem().resolveArtifact(this.aether.getSession(), artifactRequest);
            return artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            if (logUnresolvedArtifact) {
                log.warn("Unable to resolve artifact: " + artifactName, (Throwable)e);
            }
            return null;
        }
    }

    public Version resolveVersion(String artifactName) {
        DefaultArtifact artifact = new DefaultArtifact(artifactName);
        VersionRangeRequest versionRequest = new VersionRangeRequest();
        versionRequest.setArtifact(artifact);
        for (RemoteRepository repo : this.remoteRepositoriesForRequest) {
            versionRequest.addRepository(repo);
        }
        try {
            VersionRangeResult versionRangeResult = this.aether.getSystem().resolveVersionRange(this.aether.getSession(), versionRequest);
            return versionRangeResult.getHighestVersion();
        }
        catch (VersionRangeResolutionException e) {
            log.warn("Unable to resolve version range for artifact: " + artifactName, (Throwable)e);
            return null;
        }
    }

    public void deployArtifact(ReleaseId releaseId, InternalKieModule kieModule, File pomfile) {
        File jarFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName(releaseId, null) + ".jar");
        try {
            FileOutputStream fos = new FileOutputStream(jarFile);
            fos.write(kieModule.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deployArtifact(releaseId, jarFile, pomfile);
    }

    public void deployArtifact(ReleaseId releaseId, byte[] jarContent, byte[] pomContent) {
        File jarFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName(releaseId, null) + ".jar");
        try {
            FileOutputStream fos = new FileOutputStream(jarFile);
            fos.write(jarContent);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName(releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomContent);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deployArtifact(releaseId, jarFile, pomFile);
    }

    public void deployArtifact(ReleaseId releaseId, File jar, File pomfile) {
        Artifact jarArtifact = new DefaultArtifact(releaseId.getGroupId(), releaseId.getArtifactId(), "jar", releaseId.getVersion());
        jarArtifact = jarArtifact.setFile(jar);
        Artifact pomArtifact = new SubArtifact(jarArtifact, "", "pom");
        pomArtifact = pomArtifact.setFile(pomfile);
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.addArtifact(jarArtifact).addArtifact(pomArtifact).setRepository(this.aether.getLocalRepository());
        try {
            this.aether.getSystem().deploy(this.aether.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public void deployPomArtifact(String groupId, String artifactId, String version, File pomfile) {
        Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "pom", version);
        pomArtifact = pomArtifact.setFile(pomfile);
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.addArtifact(pomArtifact).setRepository(this.aether.getLocalRepository());
        try {
            this.aether.getSystem().deploy(this.aether.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toFileName(ReleaseId releaseId, String classifier) {
        if (classifier != null) {
            return releaseId.getArtifactId() + "-" + releaseId.getVersion() + "-" + classifier;
        }
        return releaseId.getArtifactId() + "-" + releaseId.getVersion();
    }

    public void renewSession() {
        this.aether.renewSession();
    }

    private static class CollectDependencyVisitor
    implements DependencyVisitor {
        private final List<DependencyNode> dependencies = new ArrayList<DependencyNode>();

        private CollectDependencyVisitor() {
        }

        @Override
        public boolean visitEnter(DependencyNode node) {
            this.dependencies.add(node);
            return true;
        }

        @Override
        public boolean visitLeave(DependencyNode node) {
            return true;
        }

        public List<DependencyNode> getDependencies() {
            return this.dependencies;
        }
    }
}

