/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.SessionScoped;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Named(value="reactor")
@SessionScoped
class ReactorReader
implements WorkspaceReader {
    public static final String HINT = "reactor";
    private static final Collection<String> COMPILE_PHASE_TYPES = Arrays.asList("jar", "ejb-client");
    private Map<String, MavenProject> projectsByGAV;
    private Map<String, List<MavenProject>> projectsByGA;
    private WorkspaceRepository repository;

    @Inject
    public ReactorReader(MavenSession session) {
        this.projectsByGAV = session.getProjectMap();
        this.projectsByGA = new HashMap<String, List<MavenProject>>(this.projectsByGAV.size() * 2);
        for (MavenProject project : this.projectsByGAV.values()) {
            String key = ArtifactUtils.versionlessKey(project.getGroupId(), project.getArtifactId());
            List<MavenProject> projects = this.projectsByGA.get(key);
            if (projects == null) {
                projects = new ArrayList<MavenProject>(1);
                this.projectsByGA.put(key, projects);
            }
            projects.add(project);
        }
        this.repository = new WorkspaceRepository(HINT, new HashSet<String>(this.projectsByGAV.keySet()));
    }

    @Override
    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    @Override
    public File findArtifact(Artifact artifact) {
        String projectKey = ArtifactUtils.key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        MavenProject project = this.projectsByGAV.get(projectKey);
        if (project != null) {
            File file = this.find(project, artifact);
            if (file == null && project != project.getExecutionProject()) {
                file = this.find(project.getExecutionProject(), artifact);
            }
            return file;
        }
        return null;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        String key = ArtifactUtils.versionlessKey(artifact.getGroupId(), artifact.getArtifactId());
        List<MavenProject> projects = this.projectsByGA.get(key);
        if (projects == null || projects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> versions = new ArrayList<String>();
        for (MavenProject project : projects) {
            if (this.find(project, artifact) == null) continue;
            versions.add(project.getVersion());
        }
        return Collections.unmodifiableList(versions);
    }

    private File find(MavenProject project, Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return project.getFile();
        }
        Artifact projectArtifact = this.findMatchingArtifact(project, artifact);
        if (this.hasArtifactFileFromPackagePhase(projectArtifact)) {
            return projectArtifact.getFile();
        }
        if (!this.hasBeenPackaged(project)) {
            if (ReactorReader.isTestArtifact(artifact)) {
                if (project.hasLifecyclePhase("test-compile")) {
                    return new File(project.getBuild().getTestOutputDirectory());
                }
            } else {
                String type = artifact.getProperty("type", "");
                if (project.hasLifecyclePhase("compile") && COMPILE_PHASE_TYPES.contains(type)) {
                    return new File(project.getBuild().getOutputDirectory());
                }
            }
        }
        return null;
    }

    private boolean hasArtifactFileFromPackagePhase(Artifact projectArtifact) {
        return projectArtifact != null && projectArtifact.getFile() != null && projectArtifact.getFile().exists();
    }

    private boolean hasBeenPackaged(MavenProject project) {
        return project.hasLifecyclePhase("package") || project.hasLifecyclePhase("install") || project.hasLifecyclePhase("deploy");
    }

    private Artifact findMatchingArtifact(MavenProject project, Artifact requestedArtifact) {
        Artifact mainArtifact;
        String requestedRepositoryConflictId = ArtifactIdUtils.toVersionlessId(requestedArtifact);
        if (requestedRepositoryConflictId.equals(ArtifactIdUtils.toVersionlessId(mainArtifact = RepositoryUtils.toArtifact(project.getArtifact())))) {
            return mainArtifact;
        }
        for (Artifact attachedArtifact : RepositoryUtils.toArtifacts(project.getAttachedArtifacts())) {
            if (!this.attachedArtifactComparison(requestedArtifact, attachedArtifact)) continue;
            return attachedArtifact;
        }
        return null;
    }

    private boolean attachedArtifactComparison(Artifact requested, Artifact attached) {
        return requested.getArtifactId().equals(attached.getArtifactId()) && requested.getGroupId().equals(attached.getGroupId()) && requested.getVersion().equals(attached.getVersion()) && requested.getExtension().equals(attached.getExtension()) && requested.getClassifier().equals(attached.getClassifier());
    }

    private static boolean isTestArtifact(Artifact artifact) {
        return "test-jar".equals(artifact.getProperty("type", "")) || "jar".equals(artifact.getExtension()) && "tests".equals(artifact.getClassifier());
    }
}

