/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.appformer.maven.integration.IoUtils;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.appformer.maven.integration.embedder.MavenSettings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aether {
    private static final Logger log = LoggerFactory.getLogger(Aether.class);
    private String localRepoDir;
    private final boolean offline;
    public static Aether instance;
    private final RepositorySystem system;
    private RepositorySystemSession session;
    private final Collection<RemoteRepository> repositories;
    private RemoteRepository localRepository;

    public Aether(MavenProject mavenProject) {
        this(MavenSettings.getSettings(), mavenProject);
    }

    public static synchronized Aether getAether() {
        if (instance == null) {
            Settings settings = MavenSettings.getSettings();
            instance = new Aether(settings, MavenProjectLoader.loadMavenProject(settings.isOffline()));
        }
        return instance;
    }

    private Aether(Settings settings, MavenProject mavenProject) {
        this.localRepoDir = settings.getLocalRepository();
        this.offline = settings.isOffline();
        this.system = this.newRepositorySystem();
        this.session = this.newRepositorySystemSession(settings, this.system);
        this.repositories = this.initRepositories(mavenProject);
    }

    private Collection<RemoteRepository> initRepositories(MavenProject mavenProject) {
        RemoteRepository localRepo;
        HashSet<RemoteRepository> reps = new HashSet<RemoteRepository>();
        reps.add(this.newCentralRepository());
        if (mavenProject != null) {
            reps.addAll(mavenProject.getRemoteProjectRepositories());
        }
        if ((localRepo = this.newLocalRepository()) != null) {
            this.localRepository = localRepo;
        }
        return reps;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setServices(WagonProvider.class, new ManualWagonProvider());
        return locator.getService(RepositorySystem.class);
    }

    private RepositorySystemSession newRepositorySystemSession(Settings settings, RepositorySystem system) {
        LocalRepository localRepo = new LocalRepository(this.localRepoDir);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(session, localRepo));
        session.setOffline(this.offline);
        this.configureProxiesOnSession(settings, session);
        this.configureHttpHeadersOnSession(settings, session);
        return session;
    }

    private void configureProxiesOnSession(Settings settings, DefaultRepositorySystemSession session) {
        List<org.apache.maven.settings.Proxy> proxies = settings.getProxies();
        if (proxies == null || proxies.isEmpty()) {
            return;
        }
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : proxies) {
            proxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort()), proxy.getNonProxyHosts());
        }
        session.setProxySelector(proxySelector);
    }

    private void configureHttpHeadersOnSession(Settings settings, DefaultRepositorySystemSession session) {
        List<Server> servers = settings.getServers();
        if (servers == null || servers.isEmpty()) {
            return;
        }
        for (Server server : servers) {
            Xpp3Dom[] properties;
            Xpp3Dom headersConfiguration;
            Xpp3Dom configDom;
            if (!(server.getConfiguration() instanceof Xpp3Dom) || (configDom = (Xpp3Dom)server.getConfiguration()) == null || (headersConfiguration = configDom.getChild("httpHeaders")) == null || (properties = headersConfiguration.getChildren()) == null || properties.length <= 0) continue;
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            for (Xpp3Dom property : properties) {
                httpHeaders.put(property.getChild("name").getValue(), property.getChild("value").getValue());
            }
            session.setConfigProperty("aether.connector.http.headers." + server.getId(), httpHeaders);
        }
    }

    private RemoteRepository newCentralRepository() {
        return new RemoteRepository.Builder("central", "default", "http://repo1.maven.org/maven2/").build();
    }

    private RemoteRepository newLocalRepository() {
        File m2RepoDir = new File(this.localRepoDir);
        try {
            if (!m2RepoDir.exists()) {
                log.info("The local repository directory " + this.localRepoDir + " doesn't exist. Creating it.");
                m2RepoDir.mkdirs();
            }
            String localRepositoryUrl = m2RepoDir.toURI().toURL().toExternalForm();
            return new RemoteRepository.Builder("local", "default", localRepositoryUrl).build();
        }
        catch (Exception e) {
            try {
                log.warn("Cannot use directory " + this.localRepoDir + " as local repository.", (Throwable)e);
                this.localRepoDir = IoUtils.getTmpDirectory().getAbsolutePath();
                log.warn("Using the temporary directory " + this.localRepoDir + " as local repository");
                m2RepoDir = new File(this.localRepoDir);
                String localRepositoryUrl = m2RepoDir.toURI().toURL().toExternalForm();
                return new RemoteRepository.Builder("local", "default", localRepositoryUrl).build();
            }
            catch (Exception e1) {
                log.warn("Cannot create a local repository in " + this.localRepoDir, (Throwable)e1);
                return null;
            }
        }
    }

    public RepositorySystem getSystem() {
        return this.system;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public Collection<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public RemoteRepository getLocalRepository() {
        return this.localRepository;
    }

    private static class ManualWagonProvider
    implements WagonProvider {
        private ManualWagonProvider() {
        }

        @Override
        public Wagon lookup(String roleHint) throws Exception {
            if ("http".equals(roleHint) || "https".equals(roleHint)) {
                return new HttpWagon();
            }
            if ("sramp".equals(roleHint)) {
                try {
                    return (Wagon)Class.forName("org.overlord.dtgov.jbpm.util.SrampWagonProxy").newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    log.warn("Cannot find sramp wagon implementation class", (Throwable)cnfe);
                }
            }
            return null;
        }

        @Override
        public void release(Wagon wagon) {
        }
    }
}

