/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;

public class MavenRepositoryConfiguration {
    private final Settings settings;
    private final Collection<RemoteRepository> extraRepositories;
    private final Collection<RemoteRepository> remoteRepositoriesForRequest;
    private final Collection<ArtifactRepository> artifactRepositoriesForRequest;

    public MavenRepositoryConfiguration(Settings settings) {
        this.settings = settings;
        this.extraRepositories = this.initExtraRepositories();
        this.remoteRepositoriesForRequest = this.initRemoteRepositoriesForRequest();
        this.artifactRepositoriesForRequest = this.initArtifactRepositories();
    }

    protected String getLocalRepository() {
        return this.settings.getLocalRepository();
    }

    public List<Proxy> getProxies() {
        return this.settings.getProxies();
    }

    public Collection<RemoteRepository> getExtraRepositories() {
        return this.extraRepositories;
    }

    public Collection<RemoteRepository> getRemoteRepositoriesForRequest() {
        return this.remoteRepositoriesForRequest;
    }

    public Collection<ArtifactRepository> getArtifactRepositoriesForRequest() {
        return this.artifactRepositoriesForRequest;
    }

    private Collection<RemoteRepository> initExtraRepositories() {
        HashSet<RemoteRepository> extraRepositories = new HashSet<RemoteRepository>();
        for (Profile profile : this.settings.getProfiles()) {
            if (!this.isProfileActive(profile)) continue;
            for (Repository repository : profile.getRepositories()) {
                extraRepositories.add(MavenRepositoryConfiguration.toRemoteRepositoryBuilder(this.settings, repository).build());
            }
            for (Repository repository : profile.getPluginRepositories()) {
                extraRepositories.add(MavenRepositoryConfiguration.toRemoteRepositoryBuilder(this.settings, repository).build());
            }
        }
        return extraRepositories;
    }

    private Collection<RemoteRepository> initRemoteRepositoriesForRequest() {
        HashSet<RemoteRepository> remoteRepos = new HashSet<RemoteRepository>();
        for (RemoteRepository repo : this.extraRepositories) {
            remoteRepos.add(this.resolveMirroredRepo(repo));
        }
        return remoteRepos;
    }

    private Collection<ArtifactRepository> initArtifactRepositories() {
        HashSet<ArtifactRepository> artifactRepos = new HashSet<ArtifactRepository>();
        for (RemoteRepository remoteRepository : this.remoteRepositoriesForRequest) {
            artifactRepos.add(this.toArtifactRepository(remoteRepository));
        }
        return artifactRepos;
    }

    public RemoteRepository resolveMirroredRepo(RemoteRepository repo) {
        for (Mirror mirror : this.settings.getMirrors()) {
            if (!this.isMirror(repo, mirror.getMirrorOf())) continue;
            return MavenRepositoryConfiguration.toRemoteRepositoryBuilder(this.settings, mirror.getId(), mirror.getLayout(), mirror.getUrl()).build();
        }
        return repo;
    }

    private boolean isMirror(RemoteRepository repo, String mirrorOf) {
        return mirrorOf.equals("*") || mirrorOf.equals("external:*") && !repo.getUrl().startsWith("file:") || mirrorOf.contains("external:*") && !repo.getUrl().startsWith("file:") && !mirrorOf.contains("!" + repo.getId()) || mirrorOf.startsWith("*") && !mirrorOf.contains("!" + repo.getId()) || !mirrorOf.startsWith("*") && !mirrorOf.contains("external:*") && mirrorOf.contains(repo.getId());
    }

    private boolean isProfileActive(Profile profile) {
        return this.settings.getActiveProfiles().contains(profile.getId()) || profile.getActivation() != null && profile.getActivation().isActiveByDefault();
    }

    private static RemoteRepository.Builder toRemoteRepositoryBuilder(Settings settings, Repository repository) {
        RemoteRepository.Builder remoteBuilder = MavenRepositoryConfiguration.toRemoteRepositoryBuilder(settings, repository.getId(), repository.getLayout(), repository.getUrl());
        MavenRepositoryConfiguration.setPolicy(remoteBuilder, repository.getSnapshots(), true);
        MavenRepositoryConfiguration.setPolicy(remoteBuilder, repository.getReleases(), false);
        return remoteBuilder;
    }

    private static RemoteRepository.Builder toRemoteRepositoryBuilder(Settings settings, String id, String layout, String url) {
        RemoteRepository.Builder remoteBuilder = new RemoteRepository.Builder(id, layout, url);
        Server server = settings.getServer(id);
        if (server != null) {
            remoteBuilder.setAuthentication(new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).build());
        }
        return remoteBuilder;
    }

    private static void setPolicy(RemoteRepository.Builder builder, org.apache.maven.settings.RepositoryPolicy policy, boolean snapshot) {
        if (policy != null) {
            RepositoryPolicy repoPolicy = new RepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
            if (snapshot) {
                builder.setSnapshotPolicy(repoPolicy);
            } else {
                builder.setReleasePolicy(repoPolicy);
            }
        }
    }

    private ArtifactRepository toArtifactRepository(RemoteRepository remoteRepository) {
        String id = remoteRepository.getId();
        String url = remoteRepository.getUrl();
        DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
        ArtifactRepositoryPolicy snapshots = new ArtifactRepositoryPolicy();
        ArtifactRepositoryPolicy releases = new ArtifactRepositoryPolicy();
        if (remoteRepository.getPolicy(true) != null) {
            snapshots = new ArtifactRepositoryPolicy(remoteRepository.getPolicy(true).isEnabled(), remoteRepository.getPolicy(true).getUpdatePolicy(), remoteRepository.getPolicy(true).getChecksumPolicy());
        }
        if (remoteRepository.getPolicy(false) != null) {
            releases = new ArtifactRepositoryPolicy(remoteRepository.getPolicy(false).isEnabled(), remoteRepository.getPolicy(false).getUpdatePolicy(), remoteRepository.getPolicy(false).getChecksumPolicy());
        }
        MavenArtifactRepository artifactRepository = new MavenArtifactRepository(id, url, layout, snapshots, releases);
        Server server = this.settings.getServer(id);
        if (server != null) {
            artifactRepository.setAuthentication(new Authentication(server.getUsername(), server.getPassword()));
        }
        return artifactRepository;
    }
}

