/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.runtime.KieContainer;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.MavenRepository;

public class KieModuleMavenTest
extends AbstractKieCiTest {
    @Test
    public void testKieModuleFromMavenNoDependencies() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, true, "rule1", "rule2");
        String pomText = this.getPom(releaseId, null);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MavenRepository.getMavenRepository().deployArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBaseModel kbaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
        Assert.assertNotNull((String)"Default kbase was not found", (Object)kbaseModel);
        String kbaseName = kbaseModel.getName();
        Assert.assertEquals((Object)"KBase1", (Object)kbaseName);
    }

    @Test
    public void testKieModuleFromMavenWithDependencies() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, true, "rule1", "rule2");
        String pomText = this.getPom(releaseId, dependency);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MavenRepository.getMavenRepository().deployArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBaseModel kbaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
        Assert.assertNotNull((String)"Default kbase was not found", (Object)kbaseModel);
        String kbaseName = kbaseModel.getName();
        Assert.assertEquals((Object)"KBase1", (Object)kbaseName);
    }
}

