/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.IOException;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.io.Resource;
import org.kie.api.runtime.conf.ClockTypeOption;

public class AbstractKieCiTest {
    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, boolean isdefault, String ... rules) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, isdefault);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        for (String rule : rules) {
            String file = "org/test/" + rule + ".drl";
            kfs.write("src/main/resources/KBase1/" + file, this.createDRL(rule));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, String ... rules) throws IOException {
        return this.createKieJar(ks, releaseId, false, rules);
    }

    protected InternalKieModule createKieJarWithClass(KieServices ks, ReleaseId releaseId, boolean useTypeDeclaration, int value, int factor, ReleaseId ... dependencies) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, dependencies));
        if (useTypeDeclaration) {
            kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRLWithTypeDeclaration(value, factor));
        } else {
            kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRLForJavaSource(value)).write("src/main/java/org/kie/test/Bean.java", this.createJavaSource(factor));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        return this.createKieFileSystemWithKProject(ks, false);
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks, boolean isdefault) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setDefault(isdefault).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("KSession1").setDefault(isdefault).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime"));
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n" + "  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n" + "  <version>" + releaseId.getVersion() + "</version>\n" + "\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected String createDRL(String ruleName) {
        return "package org.kie.test\nglobal java.util.List list\nrule " + ruleName + "\n" + "when\n" + "then\n" + "list.add( drools.getRule().getName() );\n" + "end\n";
    }

    private String createJavaSource(int factor) {
        return "package org.kie.test;\nimport org.kie.api.definition.type.Role;\n@Role(Role.Type.EVENT)\npublic class Bean {\n   private final int value;\n   public Bean(int value) {\n       this.value = value;\n   }\n   public int getValue() {\n       return value * " + factor + ";\n" + "   }\n" + "}";
    }

    private String createDRLForJavaSource(int value) {
        return "package org.kie.test\nglobal java.util.List list\nrule Init salience 100\nwhen\nthen\ninsert( new Bean(" + value + ") );\n" + "end\n" + "rule R1\n" + "when\n" + "   $b : Bean()\n" + "then\n" + "   list.add( $b.getValue() );\n" + "end\n";
    }

    protected String createDRLWithTypeDeclaration(int value, int factor) {
        return "package org.kie.test\n" + this.getDRLWithType() + this.getDRLWithRules(value, factor);
    }

    protected String getDRLWithType() {
        return "declare Bean @role(event)\n   value : int\nend\n";
    }

    protected String getDRLWithRules(int value, int factor) {
        return "global java.util.List list\nrule Init salience 100\nwhen\nthen\ninsert( new Bean(" + value + ") );\n" + "end\n" + "rule R1\n" + "when\n" + "   $b : Bean()\n" + "then\n" + "   list.add( $b.getValue() * " + factor + " );\n" + "end\n";
    }

    public static byte[] createKJar(KieServices ks, ReleaseId releaseId, String pom, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem();
        if (pom != null) {
            kfs.write("pom.xml", pom);
        } else {
            kfs.generateAndWritePomXML(releaseId);
        }
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/r" + i + ".drl", drls[i]);
        }
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            for (Message result : kb.getResults().getMessages()) {
                System.out.println(result.getText());
            }
            return null;
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    public static KieModule deployJar(KieServices ks, byte[] jar) {
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        return km;
    }
}

