/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import junit.framework.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.AbstractKieCiTest;

public class KieModuleIncrementalCompilationTest
extends AbstractKieCiTest {
    @Test
    public void testIncrementalCompilationFirstBuildHasErrors() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "incremental-test-with-invalid pom", "");
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        String drl1 = "rule R1 when\n   $s : String()\nthen\nend\n";
        String drl2 = "rule R2 when\n   $s : Strin( )\nthen\nend\n";
        kfs.write("src/main/resources/KBase1/r1.drl", drl1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((int)1, (int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        kfs.write("src/main/resources/KBase1/r2.drl", drl2);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/KBase1/r2.drl"}).build();
        Assert.assertEquals((int)1, (int)addResults.getAddedMessages().size());
        Assert.assertEquals((int)0, (int)addResults.getRemovedMessages().size());
    }
}

