/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.rule.TypeMetaInfo;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.type.Role;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieModuleMetaData;
import org.kie.scanner.MavenRepository;

public class KieModuleMetaDataTest
extends AbstractKieCiTest {
    @Test
    @Ignore
    public void testKieModuleMetaData() throws Exception {
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((ReleaseId)releaseId);
        this.checkDroolsCoreDep(kieModuleMetaData);
    }

    @Test
    public void testKieModuleMetaDataInMemoryWithJavaClass() throws Exception {
        this.testKieModuleMetaDataInMemory(false);
    }

    @Test
    public void testKieModuleMetaDataInMemoryWithTypeDeclaration() throws Exception {
        this.testKieModuleMetaDataInMemory(true);
    }

    @Test
    public void testKieModuleMetaDataInMemoryUsingPOMWithTypeDeclaration() throws Exception {
        this.testKieModuleMetaDataInMemoryUsingPOM(true);
    }

    @Test
    public void testKieModuleMetaDataForDependenciesInMemory() throws Exception {
        this.testKieModuleMetaDataForDependenciesInMemory(false);
    }

    @Test
    public void testKieModuleMetaDataInMemoryWithJavaClassDefaultPackage() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "javaDefaultPackage", "1.0-SNAPSHOT");
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML()).writePomXML(KieBuilderImpl.generatePomXml((ReleaseId)releaseId)).write("src/main/java/test/Bean.java", this.createJavaSource());
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertTrue((boolean)messages.isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        Class beanClass = kieModuleMetaData.getClass("", "test.Bean");
        Assert.assertNotNull((Object)beanClass);
        TypeMetaInfo beanMetaInfo = kieModuleMetaData.getTypeMetaInfo(beanClass);
        Assert.assertNotNull((Object)beanMetaInfo);
    }

    @Test
    public void testGetPackageNames() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/test.drl", "package org.test declare Bean end");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertTrue((boolean)messages.isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        TestCase.assertFalse((boolean)kieModuleMetaData.getPackages().isEmpty());
        TestCase.assertTrue((boolean)kieModuleMetaData.getPackages().contains("org.test"));
    }

    @Test
    public void testGetRuleNames() {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/test1.drl", "package org.test\nrule A\n when\nthen\nend\nrule B\n when\nthen\nend\n");
        kfs.write("src/main/resources/test2.drl", "package org.test\nrule C\n when\nthen\nend\n");
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertTrue((boolean)messages.isEmpty());
        KieModule kieModule = kieBuilder.getKieModule();
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        Collection rules = kieModuleMetaData.getRuleNamesInPackage("org.test");
        Assert.assertEquals((int)3, (int)rules.size());
        Assert.assertTrue((boolean)rules.containsAll(Arrays.asList("A", "B", "C")));
    }

    private String createJavaSource() {
        return "package test;\npublic class Bean {\n   private int value;\n   public int getValue() {\n       return value;\n   }\n}";
    }

    private void testKieModuleMetaDataInMemory(boolean useTypeDeclaration) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "metadata-test", "1.0-SNAPSHOT");
        InternalKieModule kieModule = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 2, 7, dependency);
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        this.checkDroolsCoreDep(kieModuleMetaData);
        Collection testClasses = kieModuleMetaData.getClasses("org.kie.test");
        Assert.assertEquals((int)1, (int)testClasses.size());
        Assert.assertEquals((String)"Bean", (String)((String)testClasses.iterator().next()));
        Class beanClass = kieModuleMetaData.getClass("org.kie.test", "Bean");
        Assert.assertNotNull((Object)beanClass.getMethod("getValue", new Class[0]));
        TypeMetaInfo beanTypeInfo = kieModuleMetaData.getTypeMetaInfo(beanClass);
        Assert.assertNotNull((Object)beanTypeInfo);
        Assert.assertTrue((boolean)beanTypeInfo.isEvent());
        Role role = beanClass.getAnnotation(Role.class);
        Assert.assertNotNull((Object)role);
        Assert.assertEquals((Object)Role.Type.EVENT, (Object)role.value());
        Assert.assertEquals((boolean)useTypeDeclaration, (boolean)beanTypeInfo.isDeclaredType());
    }

    private void testKieModuleMetaDataInMemoryUsingPOM(boolean useTypeDeclaration) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "metadata-test", "1.0-SNAPSHOT");
        InternalKieModule kieModule = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 2, 7, dependency);
        String pomText = this.getPom(dependency, new ReleaseId[0]);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MavenRepository.getMavenRepository().deployArtifact(releaseId, kieModule, pomFile);
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "metadata-test-using-pom", "1.0-SNAPSHOT");
        String pomText2 = this.getPom(releaseId2, releaseId);
        File pomFile2 = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId2, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile2);
            fos.write(pomText2.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((File)pomFile2);
        Collection testClasses = kieModuleMetaData.getClasses("org.kie.test");
        Assert.assertEquals((int)1, (int)testClasses.size());
        Assert.assertEquals((String)"Bean", (String)((String)testClasses.iterator().next()));
        Class beanClass = kieModuleMetaData.getClass("org.kie.test", "Bean");
        Assert.assertNotNull((Object)beanClass.getMethod("getValue", new Class[0]));
        if (useTypeDeclaration) {
            Assert.assertTrue((boolean)kieModuleMetaData.getTypeMetaInfo(beanClass).isEvent());
        }
    }

    private void checkDroolsCoreDep(KieModuleMetaData kieModuleMetaData) {
        Assert.assertEquals((int)17, (int)kieModuleMetaData.getClasses("org.drools.runtime").size());
        Class statefulKnowledgeSessionClass = kieModuleMetaData.getClass("org.drools.runtime", "StatefulKnowledgeSession");
        Assert.assertTrue((boolean)statefulKnowledgeSessionClass.isInterface());
        Assert.assertEquals((int)2, (int)statefulKnowledgeSessionClass.getDeclaredMethods().length);
    }

    private void testKieModuleMetaDataForDependenciesInMemory(boolean useTypeDeclaration) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId dependency = ks.newReleaseId("org.drools", "drools-core", "5.5.0.Final");
        ReleaseId releaseId = ks.newReleaseId("org.kie", "metadata-test", "1.0-SNAPSHOT");
        InternalKieModule kieModule = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 2, 7, dependency);
        KieModuleMetaData kieModuleMetaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)kieModule);
        this.checkDroolsCoreDep(kieModuleMetaData);
        Collection testClasses = kieModuleMetaData.getClasses("org.drools");
        Assert.assertEquals((int)55, (int)testClasses.size());
        Class beanClass = kieModuleMetaData.getClass("org.drools", "QueryResult");
        Assert.assertNotNull((Object)beanClass);
        TypeMetaInfo beanTypeInfo = kieModuleMetaData.getTypeMetaInfo(beanClass);
        Assert.assertNotNull((Object)beanTypeInfo);
        if (useTypeDeclaration) {
            Assert.assertTrue((boolean)beanTypeInfo.isEvent());
        }
        Assert.assertEquals((boolean)useTypeDeclaration, (boolean)beanTypeInfo.isDeclaredType());
    }
}

