/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.core.util.FileManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.MavenRepository;

@Ignore
public class KieRepositoryScannerTest
extends AbstractKieCiTest {
    private FileManager fileManager;
    private File kPom;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        this.kPom = this.createKPom(this.fileManager, releaseId, new ReleaseId[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    private void resetFileManager() {
        this.fileManager.tearDown();
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @Test
    public void testKScanner() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, "rule1", "rule2");
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, this.kPom);
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId, "rule2", "rule3");
        repository.deployArtifact(releaseId, kJar2, this.kPom);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2", "rule3");
        ks.getRepository().removeKieModule(releaseId);
    }

    @Test
    public void testKScannerWithRange() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "scanner-range-test", "1.0.1");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "scanner-range-test", "1.0.2");
        ReleaseId releaseRange = ks.newReleaseId("org.kie", "scanner-range-test", "[1.0.0,)");
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId1, "rule1", "rule2");
        KieContainer kieContainer = ks.newKieContainer(releaseRange);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId1, kJar1, this.kPom);
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1", "rule2");
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId2, "rule2", "rule3");
        repository.deployArtifact(releaseId2, kJar2, this.kPom);
        InternalKieScanner scanner = (InternalKieScanner)ks.newKieScanner(kieContainer);
        Assert.assertEquals((Object)releaseId1, (Object)scanner.getCurrentReleaseId());
        Assert.assertEquals((Object)InternalKieScanner.Status.STOPPED, (Object)scanner.getStatus());
        scanner.scanNow();
        Assert.assertEquals((Object)releaseId2, (Object)scanner.getCurrentReleaseId());
        Assert.assertEquals((Object)InternalKieScanner.Status.STOPPED, (Object)scanner.getStatus());
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2", "rule3");
    }

    @Test
    public void testKScannerWithKJarContainingClasses() throws Exception {
        this.testKScannerWithType(false);
    }

    @Test
    public void testKScannerWithKJarContainingTypeDeclaration() throws Exception {
        this.testKScannerWithType(true);
    }

    private void testKScannerWithType(boolean useTypeDeclaration) throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 2, 7, new ReleaseId[0]);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(releaseId, kJar1, this.kPom);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, 14);
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, releaseId, useTypeDeclaration, 3, 5, new ReleaseId[0]);
        repository.deployArtifact(releaseId, kJar2, this.kPom);
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, 15);
        ks.getRepository().removeKieModule(releaseId);
    }

    @Test
    public void testLoadKieJarFromMavenRepo() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.newKieContainer(ks.newReleaseId("org.kie", "scanner-test", "1.0-SNAPSHOT"));
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, 15);
    }

    @Test
    public void testScannerOnPomProject() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "scanner-test", "1.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "scanner-test", "2.0");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployPomArtifact("org.kie", "scanner-master-test", "1.0", this.createMasterKPom("scanner-test"));
        this.resetFileManager();
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, releaseId1, false, 2, 7, new ReleaseId[0]);
        repository.deployArtifact(releaseId1, kJar1, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(ks.newReleaseId("org.kie", "scanner-master-test", "LATEST"));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, 14);
        KieScanner scanner = ks.newKieScanner(kieContainer);
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, releaseId2, false, 3, 5, new ReleaseId[0]);
        repository.deployArtifact(releaseId2, kJar2, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, 15);
    }

    private File createMasterKPom(String depArtifactId) throws IOException {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>org.kie</groupId>\n  <artifactId>scanner-master-test</artifactId>\n  <version>1.0</version>\n  <packaging>pom</packaging>\n\n    <dependencies>\n      <dependency>\n        <groupId>org.kie</groupId>\n        <artifactId>" + depArtifactId + "</artifactId>\n" + "        <version>LATEST</version>\n" + "      </dependency>\n" + "    </dependencies>\n" + "</project>";
        File pomFile = this.fileManager.newFile("pom.xml");
        this.fileManager.write(pomFile, pom);
        return pomFile;
    }

    private void checkKSession(KieSession ksession, Object ... results) {
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)results.length, (long)list.size());
        for (Object result : results) {
            Assert.assertTrue((boolean)list.contains(result));
        }
    }

    @Test
    public void testKieScannerOnClasspathContainerMustFail() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = ks.getKieClasspathContainer();
        try {
            KieScanner scanner = ks.newKieScanner(kieContainer);
            Assert.fail((String)"Creating a KieScanner from a KieClasspathContainer must fail");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testTypeAndRuleInDifferentKieModules() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId depId = ks.newReleaseId("org.kie", "test-types", "1.0");
        InternalKieModule kJar1 = this.createKieJarWithType(ks, depId);
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployArtifact(depId, kJar1, this.kPom);
        ReleaseId releaseId = ks.newReleaseId("org.kie", "test-rules", "1.0");
        InternalKieModule kieModule = this.createKieJarWithRules(ks, releaseId, depId);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, 15);
    }

    private InternalKieModule createKieJarWithType(KieServices ks, ReleaseId releaseId) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.write("src/main/resources/KBase1/r1.drl", "package org.kie.test\n" + this.getDRLWithType());
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    private InternalKieModule createKieJarWithRules(KieServices ks, ReleaseId releaseId, ReleaseId depId) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.write("src/main/resources/KBase1/r1.drl", "package org.kie.test\n" + this.getDRLWithRules(3, 5));
        kfs.writePomXML(this.getPom(releaseId, depId));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        kieBuilder.buildAll();
        Assert.assertTrue((boolean)kieBuilder.getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    @Test
    public void testScannerOnPomRuleProject() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "scanner-test", "1.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "scanner-test", "2.0");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.deployPomArtifact("org.kie", "scanner-master-test", "1.0", this.createMasterKPom("scanner-test"));
        this.resetFileManager();
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId1, "rule1");
        repository.deployArtifact(releaseId1, kJar1, this.createKPom(this.fileManager, releaseId1, new ReleaseId[0]));
        KieContainer kieContainer = ks.newKieContainer(ks.newReleaseId("org.kie", "scanner-master-test", "LATEST"));
        KieSession ksession = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession, "rule1");
        KieScanner scanner = ks.newKieScanner(kieContainer);
        InternalKieModule kJar2 = this.createKieJar(ks, releaseId2, "rule2");
        repository.deployArtifact(releaseId2, kJar2, this.createKPom(this.fileManager, releaseId2, new ReleaseId[0]));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession1");
        this.checkKSession(ksession2, "rule2");
    }

    @Test
    public void testMissingDependency() throws Exception {
        KieServices ks = KieServices.Factory.get();
        MavenRepository repository = MavenRepository.getMavenRepository();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "scanner-test", "1.0");
        ReleaseId missingDep = ks.newReleaseId("org.kie", "missing-dep", "1.0");
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, missingDep));
        kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRLWithTypeDeclaration(1, 1));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messages = kieBuilder.buildAll().getResults().getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        Assert.assertTrue((boolean)((Message)messages.get(0)).toString().contains("missing-dep"));
    }

    @Test
    public void testScanIncludedDependency() throws Exception {
        MavenRepository repository = MavenRepository.getMavenRepository();
        KieServices ks = KieServices.Factory.get();
        ReleaseId containerReleaseId = KieServices.Factory.get().newReleaseId("org.kie", "test-container", "1.0.0-SNAPSHOT");
        ReleaseId includedReleaseId = KieServices.Factory.get().newReleaseId("org.kie", "test-project", "1.0.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar(ks, includedReleaseId, "rule1");
        repository.deployArtifact(includedReleaseId, kJar1, this.createKPom(this.fileManager, includedReleaseId, new ReleaseId[0]));
        this.resetFileManager();
        KieFileSystem kfs = ks.newKieFileSystem();
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("KBase2").addInclude("KBase1").newKieSessionModel("KSession2");
        kfs.writeKModuleXML(kproj.toXML());
        kfs.writePomXML(this.getPom(containerReleaseId, includedReleaseId));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        InternalKieModule containerKJar = (InternalKieModule)kieBuilder.getKieModule();
        repository.deployArtifact(containerReleaseId, containerKJar, this.createKPom(this.fileManager, containerReleaseId, includedReleaseId));
        KieContainer kieContainer = ks.newKieContainer(containerReleaseId);
        KieSession ksession = kieContainer.newKieSession("KSession2");
        this.checkKSession(ksession, "rule1");
        KieScanner scanner = ks.newKieScanner(kieContainer);
        InternalKieModule kJar2 = this.createKieJar(ks, includedReleaseId, "rule2");
        repository.deployArtifact(includedReleaseId, kJar2, this.createKPom(this.fileManager, includedReleaseId, new ReleaseId[0]));
        scanner.scanNow();
        KieSession ksession2 = kieContainer.newKieSession("KSession2");
        this.checkKSession(ksession2, "rule2");
    }
}

