/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieModuleMetaData;

public class KieModuleIncrementalCompilationTest
extends AbstractKieCiTest {
    @Test
    public void testCheckMetaDataAfterIncrementalDelete() throws Exception {
        String drl1 = "package org.kie.scanner\nrule R1 when\n   String()\nthen\nend\n";
        String drl2 = "package org.kie.scanner\nrule R2_2 when\n   String( )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl1).write("src/main/resources/r2.drl", drl2);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)2L, (long)this.getRuleNames(kieBuilder).get("org.kie.scanner").size());
        kfs.delete(new String[]{"src/main/resources/r2.drl"});
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/r2.drl"}).build();
        Assert.assertEquals((long)1L, (long)this.getRuleNames(kieBuilder).get("org.kie.scanner").size());
    }

    private HashMap<String, Collection<String>> getRuleNames(KieBuilder kieBuilder) {
        KieModuleMetaData kieModuleMetaData = this.getKieModuleMetaData(kieBuilder);
        HashMap<String, Collection<String>> ruleNames = new HashMap<String, Collection<String>>();
        for (String packageName : kieModuleMetaData.getPackages()) {
            ruleNames.put(packageName, kieModuleMetaData.getRuleNamesInPackage(packageName));
        }
        return ruleNames;
    }

    private KieModuleMetaData getKieModuleMetaData(KieBuilder kieBuilder) {
        return KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)((InternalKieBuilder)kieBuilder).getKieModuleIgnoringErrors());
    }

    @Test
    public void testIncrementalCompilationFirstBuildHasErrors() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "incremental-test-with-invalid pom", "");
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        String drl1 = "rule R1 when\n   $s : String()\nthen\nend\n";
        String drl2 = "rule R2 when\n   $s : Strin( )\nthen\nend\n";
        kfs.write("src/main/resources/KBase1/r1.drl", drl1);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)1L, (long)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
        kfs.write("src/main/resources/KBase1/r2.drl", drl2);
        IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/KBase1/r2.drl"}).build();
        Assert.assertEquals((long)1L, (long)addResults.getAddedMessages().size());
        Assert.assertEquals((long)0L, (long)addResults.getRemovedMessages().size());
    }
}

